/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.gui;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.components.BookComponent;
import fzmm.zailer.me.client.gui.components.BooleanButton;
import fzmm.zailer.me.client.gui.components.ContextMenuButton;
import fzmm.zailer.me.client.gui.components.SliderWidget;
import fzmm.zailer.me.client.gui.components.SnackBarLayout;
import fzmm.zailer.me.client.gui.components.SuggestionTextBox;
import fzmm.zailer.me.client.gui.components.image.ImageButtonComponent;
import fzmm.zailer.me.client.gui.components.image.ScreenshotZoneComponent;
import fzmm.zailer.me.client.gui.components.row.BooleanRow;
import fzmm.zailer.me.client.gui.components.row.ButtonRow;
import fzmm.zailer.me.client.gui.components.row.ColorRow;
import fzmm.zailer.me.client.gui.components.row.ConfigTextBoxRow;
import fzmm.zailer.me.client.gui.components.row.ContextMenuButtonRow;
import fzmm.zailer.me.client.gui.components.row.NumberRow;
import fzmm.zailer.me.client.gui.components.row.ScreenTabRow;
import fzmm.zailer.me.client.gui.components.row.SliderRow;
import fzmm.zailer.me.client.gui.components.row.TextBoxRow;
import fzmm.zailer.me.client.gui.components.row.image.ImageRows;
import fzmm.zailer.me.client.gui.components.snack_bar.ISnackBarScreen;
import fzmm.zailer.me.client.gui.components.style.component.StyledLabelComponent;
import fzmm.zailer.me.client.gui.components.style.container.StyledFlowLayout;
import fzmm.zailer.me.client.gui.components.style.container.StyledScrollContainer;
import fzmm.zailer.me.client.gui.components.tabs.IScreenTab;
import fzmm.zailer.me.client.gui.components.tabs.IScreenTabIdentifier;
import fzmm.zailer.me.client.gui.components.tabs.ITabsEnum;
import fzmm.zailer.me.client.gui.components.tabs.ScreenTabContainer;
import fzmm.zailer.me.client.gui.main.components.MainButtonComponent;
import fzmm.zailer.me.client.gui.text_format.components.ColorListContainer;
import fzmm.zailer.me.client.gui.utils.memento.IMemento;
import fzmm.zailer.me.client.gui.utils.memento.IMementoObject;
import fzmm.zailer.me.client.gui.utils.memento.IMementoScreen;
import fzmm.zailer.me.compat.symbol_chat.SymbolChatCompat;
import fzmm.zailer.me.compat.symbol_chat.font.FontTextBoxComponent;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.FocusHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public abstract class BaseFzmmScreen
extends BaseUIModelScreen<StyledFlowLayout>
implements ISnackBarScreen {
    @Nullable
    protected class_437 parent;
    protected final String baseScreenTranslationKey;
    public static final int BUTTON_TEXT_PADDING = 8;
    public static final int COMPONENT_DISTANCE = 8;
    private final SymbolChatCompat symbolChatCompat;
    protected final HashMap<String, IScreenTab> tabs;
    protected final FlowLayout snackBarLayout;

    public BaseFzmmScreen(String screenPath, String baseScreenTranslationKey, @Nullable class_437 parent) {
        super(StyledFlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)class_2960.method_43902((String)"fzmm", (String)screenPath)));
        this.baseScreenTranslationKey = baseScreenTranslationKey;
        this.parent = parent;
        this.tabs = new HashMap();
        this.symbolChatCompat = new SymbolChatCompat();
        this.snackBarLayout = new SnackBarLayout(Sizing.content(), Sizing.content());
    }

    protected void build(StyledFlowLayout rootComponent) {
        assert (this.field_22787 != null);
        ButtonComponent backButton = (ButtonComponent)rootComponent.childById(ButtonComponent.class, "back-button");
        if (backButton != null) {
            backButton.onPress(button -> this.method_25419());
        }
        this.symbolChatCompat.addSymbolChatComponents(this);
        this.setup(rootComponent);
        rootComponent.child((Component)this.snackBarLayout);
    }

    protected void method_25426() {
        BaseFzmmScreen baseFzmmScreen;
        super.method_25426();
        if (FzmmClient.CONFIG.history.automaticallyRecoverScreens() && (baseFzmmScreen = this) instanceof IMementoScreen) {
            IMementoScreen mementoScreen = (IMementoScreen)((Object)baseFzmmScreen);
            mementoScreen.getMemento().ifPresent(mementoScreen::restoreMemento);
        }
        if (this.getRoot().focusHandler() != null) {
            this.initFocus(this.getRoot().focusHandler());
        }
    }

    protected void initFocus(FocusHandler focusHandler) {
    }

    protected abstract void setup(FlowLayout var1);

    public void method_25432() {
        this.clearSnackBars();
        super.method_25432();
    }

    public void method_25419() {
        BaseFzmmScreen baseFzmmScreen;
        assert (this.field_22787 != null);
        this.setScreen(this.parent);
        if (FzmmClient.CONFIG.history.automaticallyRecoverScreens() && (baseFzmmScreen = this) instanceof IMementoScreen) {
            IMementoScreen mementoScreen = (IMementoScreen)((Object)baseFzmmScreen);
            try {
                mementoScreen.setMemento(mementoScreen.createMemento());
            }
            catch (NullPointerException e) {
                FzmmClient.LOGGER.error("Failed to create memento", (Throwable)e);
            }
        }
    }

    protected void setTabs(Enum<? extends ITabsEnum> tabs) {
        this.setTabs(this.tabs, tabs);
    }

    protected void setTabs(HashMap<String, IScreenTab> hashMap, Enum<? extends ITabsEnum> tabs) {
        for (Enum tab : (Enum[])tabs.getDeclaringClass().getEnumConstants()) {
            hashMap.put(((IScreenTabIdentifier)((Object)tab)).getId(), ((ITabsEnum)((Object)tab)).createTab());
        }
    }

    protected HashMap<String, IMementoObject> createMementoTabs() {
        return this.createMementoTabs(this.tabs);
    }

    protected HashMap<String, IMementoObject> createMementoTabs(HashMap<String, IScreenTab> tabsHashMap) {
        HashMap<String, IMementoObject> tabs = new HashMap<String, IMementoObject>();
        for (IScreenTab tab : tabsHashMap.values()) {
            if (!(tab instanceof IMemento)) continue;
            IMemento mementoTab = (IMemento)((Object)tab);
            tabs.put(tab.getId(), mementoTab.createMemento());
        }
        return tabs;
    }

    protected void restoreMementoTabs(HashMap<String, IMementoObject> mementoTabs) {
        this.restoreMementoTabs(mementoTabs, this.tabs);
    }

    protected void restoreMementoTabs(HashMap<String, IMementoObject> mementoTabs, HashMap<String, IScreenTab> tabsHashMap) {
        for (IScreenTab tab : tabsHashMap.values()) {
            if (!(tab instanceof IMemento)) continue;
            IMemento mementoTab = (IMemento)((Object)tab);
            mementoTab.restoreMemento(mementoTabs.get(tab.getId()));
        }
    }

    public <T extends Enum<? extends IScreenTabIdentifier>> T selectScreenTab(FlowLayout rootComponent, IScreenTabIdentifier selectedTab, T tabs) {
        return this.selectScreenTab(rootComponent, selectedTab, tabs, this.tabs, true);
    }

    public <T extends Enum<? extends IScreenTabIdentifier>> T selectScreenTab(FlowLayout rootComponent, IScreenTabIdentifier selectedTab, T tabs, HashMap<String, IScreenTab> tabsHashMap, boolean addLabel) {
        for (String tabId : tabsHashMap.keySet()) {
            ScreenTabContainer screenTabContainer = (ScreenTabContainer)rootComponent.childById(ScreenTabContainer.class, ScreenTabContainer.getScreenTabId(tabId));
            class_4185 screenTabButton = (class_4185)rootComponent.childById(class_4185.class, ScreenTabRow.getScreenTabButtonId(tabId));
            boolean isSelectedTab = selectedTab.getId().equals(tabId);
            if (screenTabContainer != null) {
                screenTabContainer.setSelected(isSelectedTab, addLabel);
            }
            if (screenTabButton == null) continue;
            screenTabButton.field_22763 = !isSelectedTab;
        }
        Optional<Enum> result = Arrays.stream((Enum[])tabs.getDeclaringClass().getEnumConstants()).filter(tab -> ((IScreenTabIdentifier)((Object)tab)).getId().equals(selectedTab.getId())).findFirst();
        assert (result.isPresent());
        return (T)result.get();
    }

    public <T extends IScreenTab> T getTab(IScreenTabIdentifier tab, Class<T> ignored) {
        return this.getTab(tab, ignored, this.tabs);
    }

    public <T extends IScreenTab> T getTab(IScreenTabIdentifier tab, Class<T> ignored, HashMap<String, IScreenTab> tabsHashMap) {
        return (T)tabsHashMap.get(tab.getId());
    }

    public String getBaseScreenTranslationKey() {
        return this.baseScreenTranslationKey;
    }

    public static String getBaseTranslationKey(Element element) {
        String string;
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (currentScreen instanceof BaseFzmmScreen) {
            BaseFzmmScreen baseFzmmScreen = (BaseFzmmScreen)currentScreen;
            string = baseFzmmScreen.getBaseScreenTranslationKey();
        } else {
            string = element.getAttribute("baseScreenTranslationKey");
        }
        return string;
    }

    public static String getBaseTranslationKey(String baseTranslationKey) {
        return "fzmm.gui." + baseTranslationKey;
    }

    public static String getTabTranslationKey(String baseScreenTranslationKey) {
        return BaseFzmmScreen.getBaseTranslationKey(baseScreenTranslationKey) + ".tab.";
    }

    public static String getOptionBaseTranslationKey(String baseScreenTranslationKey) {
        return BaseFzmmScreen.getBaseTranslationKey(baseScreenTranslationKey) + ".option.";
    }

    public void child(Component child) {
        ((StyledFlowLayout)this.uiAdapter.rootComponent).child(child);
    }

    @Override
    public FlowLayout getSnackBarLayout() {
        return this.snackBarLayout;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.symbolChatCompat.isSelectionPanelVisible()) {
                this.symbolChatCompat.setSelectionPanelVisible(false);
                return true;
            }
            if (this.symbolChatCompat.isFontSelectionVisible()) {
                this.symbolChatCompat.setFontSelectionVisible(false);
                return true;
            }
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.symbolChatCompat.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        return this.symbolChatCompat.charTyped(chr, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public SymbolChatCompat getSymbolChatCompat() {
        return this.symbolChatCompat;
    }

    @Contract(value="null, _, _ -> fail;", pure=true)
    public static void checkNull(Component component, String componentTagName, String id) {
        Objects.requireNonNull(component, String.format("No '%s' found with component titleId '%s'", componentTagName, id));
    }

    public UIModel getModel() {
        return this.model;
    }

    public FlowLayout getRoot() {
        return (FlowLayout)this.uiAdapter.rootComponent;
    }

    static {
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"boolean-row"), BooleanRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"button-row"), ButtonRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"color-row"), ColorRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"predicate-text-box-row"), ConfigTextBoxRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"context-menu-button-row"), ContextMenuButtonRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"image-rows"), ImageRows::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"number-row"), NumberRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"screen-tab-row"), ScreenTabRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"slider-row"), SliderRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"text-box-row"), TextBoxRow::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"styled-label"), element -> new StyledLabelComponent((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"styled-flow-layout"), StyledFlowLayout::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"styled-scroll"), StyledScrollContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"book"), element -> new BookComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"boolean-button"), BooleanButton::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"context-menu-button"), element -> new ContextMenuButton((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"number-slider"), element -> new SliderWidget());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"text-option"), element -> new ConfigTextBox());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"suggest-text-option"), element -> new SuggestionTextBox());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"image-option"), element -> new ImageButtonComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"screen-tab"), ScreenTabContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"main-button"), element -> new MainButtonComponent((class_2561)class_2561.method_43473(), buttonComponent -> {}));
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"screenshot-zone"), element -> new ScreenshotZoneComponent());
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"color-list"), ColorListContainer::parse);
        UIParsing.registerFactory((class_2960)class_2960.method_43902((String)"fzmm", (String)"font-text-box"), element -> new FontTextBoxComponent(Sizing.fixed((int)100)));
    }
}

