/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import fzmm.zailer.me.builders.DisplayBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.argument_type.VersionArgumentType;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.InventoryUtils;
import fzmm.zailer.me.utils.skin.GetSkinDecorator;
import fzmm.zailer.me.utils.skin.GetSkinFromCache;
import fzmm.zailer.me.utils.skin.GetSkinFromMineskin;
import fzmm.zailer.me.utils.skin.GetSkinFromMojang;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2178;
import net.minecraft.class_2179;
import net.minecraft.class_2232;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3545;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class FzmmCommand {
    private static final String BASE_COMMAND_ALIAS = "fzmm";
    private static final String BASE_COMMAND = "/fzmm";

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralArgumentBuilder fzmmCommand = ClientCommandManager.literal((String)BASE_COMMAND_ALIAS);
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"name").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.name.help", "/fzmm name <item name>"))).then(ClientCommandManager.argument((String)"name", (ArgumentType)class_2178.method_9281()).executes(ctx -> {
            class_2561 name = (class_2561)ctx.getArgument("name", class_2561.class);
            DisplayBuilder.renameHandItem(name.method_27661());
            return 1;
        })));
        fzmmCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lore").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.lore.help", "/fzmm lore add/remove"))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.lore.add.help", "/fzmm lore add <message>"))).then(ClientCommandManager.argument((String)"message", (ArgumentType)class_2178.method_9281()).executes(ctx -> {
            class_2561 message = (class_2561)ctx.getArgument("message", class_2561.class);
            DisplayBuilder.addLoreToHandItem(message.method_27661());
            return 1;
        })))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").executes(ctx -> {
            FzmmCommand.removeLore();
            return 1;
        })).then(ClientCommandManager.argument((String)"line", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Short.MAX_VALUE)).executes(ctx -> {
            FzmmCommand.removeLore((Integer)ctx.getArgument("line", Integer.TYPE));
            return 1;
        }))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"give").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.give.help", "/fzmm give <item> <amount>"))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)registryAccess)).executes(ctx -> {
            FzmmCommand.giveItem(class_2287.method_9777((CommandContext)ctx, (String)"item"), 1);
            return 1;
        })).then(ClientCommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)127)).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            class_2290 item = class_2287.method_9777((CommandContext)ctx, (String)"item");
            FzmmCommand.giveItem(item, amount);
            return 1;
        }))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"old_give").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.old_give.help", "/fzmm old_give <item> <nbt> <version_code> or old_give <item> <damage> <nbt> <version_code>"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"item", (ArgumentType)class_2232.method_9441()).executes(ctx -> {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"commands.fzmm.old_give.nbt_required").method_27692(class_124.field_1061));
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(ctx -> {
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            class_2487 nbt = class_2179.method_9285((CommandContext)ctx, (String)"nbt");
            FzmmCommand.oldGiveItem(item, nbt, VersionArgumentType.VERSIONS.get(0));
            return 1;
        })).then(ClientCommandManager.argument((String)"item_version", (ArgumentType)VersionArgumentType.version()).executes(ctx -> {
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            class_2487 nbt = class_2179.method_9285((CommandContext)ctx, (String)"nbt");
            class_3545<String, Integer> version = VersionArgumentType.getVersion((CommandContext<FabricClientCommandSource>)ctx, "item_version");
            FzmmCommand.oldGiveItem(item, nbt, version);
            return 1;
        })))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"damage", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"commands.fzmm.old_give.nbt_required").method_27692(class_124.field_1061));
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(ctx -> {
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            int damage = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"damage");
            class_2487 nbt = class_2179.method_9285((CommandContext)ctx, (String)"nbt");
            FzmmCommand.oldGiveItem(item, damage, nbt, VersionArgumentType.VERSIONS.get(0));
            return 1;
        })).then(ClientCommandManager.argument((String)"item_version", (ArgumentType)VersionArgumentType.version()).executes(ctx -> {
            class_2960 item = (class_2960)ctx.getArgument("item", class_2960.class);
            int damage = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"damage");
            class_2487 nbt = class_2179.method_9285((CommandContext)ctx, (String)"nbt");
            class_3545<String, Integer> version = VersionArgumentType.getVersion((CommandContext<FabricClientCommandSource>)ctx, "item_version");
            FzmmCommand.oldGiveItem(item, damage, nbt, version);
            return 1;
        }))))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"enchant").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.enchant.help", "/fzmm enchant <enchantment> <level>"))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(ctx -> {
            class_1887 enchant = (class_1887)((class_6880.class_6883)ctx.getArgument("enchantment", class_6880.class_6883.class)).comp_349();
            FzmmCommand.addEnchant(enchant, (short)1);
            return 1;
        })).then(ClientCommandManager.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(ctx -> {
            class_1887 enchant = (class_1887)((class_6880.class_6883)ctx.getArgument("enchantment", class_6880.class_6883.class)).comp_349();
            int level = (Integer)ctx.getArgument("level", Integer.TYPE);
            FzmmCommand.addEnchant(enchant, (short)level);
            return 1;
        }))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fakeenchant").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.fakeenchant.help", "/fzmm fakeenchant <enchantment> <level>"))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(ctx -> {
            class_1887 enchant = (class_1887)((class_6880.class_6883)ctx.getArgument("enchantment", class_6880.class_6883.class)).comp_349();
            FzmmCommand.addFakeEnchant(enchant, 1);
            return 1;
        })).then(ClientCommandManager.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            class_1887 enchant = (class_1887)((class_6880.class_6883)ctx.getArgument("enchantment", class_6880.class_6883.class)).comp_349();
            int level = (Integer)ctx.getArgument("level", Integer.TYPE);
            FzmmCommand.addFakeEnchant(enchant, level);
            return 1;
        }))));
        fzmmCommand.then(ClientCommandManager.literal((String)"nbt").executes(ctx -> {
            FzmmCommand.showNbt((CommandContext<FabricClientCommandSource>)ctx);
            return 1;
        }));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"amount").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.amount.help", "/fzmm amount <value>"))).then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> {
            int amount = (Integer)ctx.getArgument("value", Integer.TYPE);
            FzmmCommand.amount(amount);
            return 1;
        })));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skull").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.skull.help", "/fzmm skull <skull owner> cache/mineskin/mojang"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"skull owner", (ArgumentType)StringArgumentType.word()).suggests(FzmmUtils.SUGGESTION_PLAYER).executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            FzmmCommand.getHead(new GetSkinFromCache(new GetSkinFromMojang()), skullOwner);
            return 1;
        })).then(ClientCommandManager.literal((String)"cache").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            FzmmCommand.getHead(new GetSkinFromCache(), skullOwner);
            return 1;
        }))).then(ClientCommandManager.literal((String)"mineskin").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            FzmmCommand.getHead(new GetSkinFromMineskin().setCacheSkin(skullOwner), skullOwner);
            return 1;
        }))).then(ClientCommandManager.literal((String)"mojang").executes(ctx -> {
            String skullOwner = (String)ctx.getArgument("skull owner", String.class);
            FzmmCommand.getHead(new GetSkinFromMojang(), skullOwner);
            return 1;
        }))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fullcontainer").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.fullcontainer.help", "/fzmm fullcontainer <slots to fill> <first slot>"))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"slots to fill", (ArgumentType)IntegerArgumentType.integer((int)1, (int)27)).executes(ctx -> {
            FzmmCommand.fullContainer((Integer)ctx.getArgument("slots to fill", Integer.TYPE), -1);
            return 1;
        })).then(ClientCommandManager.argument((String)"first slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)26)).executes(ctx -> {
            int slotsToFill = (Integer)ctx.getArgument("slots to fill", Integer.TYPE);
            int firstSlot = (Integer)ctx.getArgument("first slot", Integer.TYPE);
            FzmmCommand.fullContainer(slotsToFill, firstSlot);
            return 1;
        }))));
        fzmmCommand.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lock").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.lock.help", "/fzmm lock <key>"))).then(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String key = (String)ctx.getArgument("key", String.class);
            FzmmCommand.lockContainer(key);
            return 1;
        })));
        fzmmCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"equip").executes(ctx -> FzmmCommand.sendHelpMessage("commands.fzmm.equip.help", "/fzmm equip <armor>"))).then(ClientCommandManager.literal((String)"head").executes(ctx -> {
            FzmmCommand.swapItemWithHand(class_1304.field_6169);
            return 1;
        }))).then(ClientCommandManager.literal((String)"chest").executes(ctx -> {
            FzmmCommand.swapItemWithHand(class_1304.field_6174);
            return 1;
        }))).then(ClientCommandManager.literal((String)"legs").executes(ctx -> {
            FzmmCommand.swapItemWithHand(class_1304.field_6172);
            return 1;
        }))).then(ClientCommandManager.literal((String)"feet").executes(ctx -> {
            FzmmCommand.swapItemWithHand(class_1304.field_6166);
            return 1;
        })));
        fzmmCommand.executes(ctx -> {
            String subcommands = String.join((CharSequence)"/", fzmmCommand.getArguments().stream().map(CommandNode::getName).toList());
            return FzmmCommand.sendHelpMessage("commands.fzmm.help", "/fzmm " + subcommands);
        });
        dispatcher.register(fzmmCommand);
    }

    private static int sendHelpMessage(String infoTranslationKey, String syntax) {
        class_5250 infoTranslation = class_2561.method_43471((String)infoTranslationKey).method_10862(class_2583.field_24360.method_36139(0xB7B7B7));
        class_5250 syntaxText = class_2561.method_43470((String)syntax).method_10862(class_2583.field_24360.method_36139(0xB7B7B7));
        class_5250 translation = class_2561.method_43469((String)"commands.fzmm.help.format", (Object[])new Object[]{infoTranslation, syntaxText}).method_10862(class_2583.field_24360.method_36139(4689479));
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        player.method_43496((class_2561)translation);
        return 1;
    }

    private static void giveItem(class_2290 item, int amount) throws CommandSyntaxException {
        class_1799 itemStack = item.method_9781(amount, false);
        FzmmUtils.giveItem(FzmmUtils.processStack(itemStack));
    }

    private static void oldGiveItem(class_2960 item, class_2487 nbtCompound, class_3545<String, Integer> oldVersion) {
        FzmmCommand.oldGiveItem(item, 0, nbtCompound, oldVersion);
    }

    private static void oldGiveItem(class_2960 item, int damage, class_2487 nbtCompound, class_3545<String, Integer> oldVersion) {
        CompletableFuture.runAsync(() -> {
            AtomicBoolean error = new AtomicBoolean(false);
            int oldVersionData = (Integer)oldVersion.method_15441();
            class_2487 fakeHotbarStorageCompound = FzmmCommand.getFakeHotbarStorageCompound(item.toString(), damage, nbtCompound, oldVersionData);
            fakeHotbarStorageCompound = class_4284.field_19215.method_48130(class_3551.method_15450(), fakeHotbarStorageCompound, oldVersionData);
            assert (class_310.method_1551().field_1687 != null);
            Optional<Object> result = Optional.empty();
            try {
                class_2487 stackCompound = fakeHotbarStorageCompound.method_10554(String.valueOf(0), 10).method_10602(0);
                result = Optional.of(class_1799.method_7915((class_2487)stackCompound));
            }
            catch (Exception e) {
                error.set(true);
                FzmmClient.LOGGER.error("[FzmmCommand] Failed to parse update item with '/fzmm old_give'", (Throwable)e);
            }
            class_338 chatHud = class_310.method_1551().field_1705.method_1743();
            class_5250 errorMessage = class_2561.method_43469((String)"commands.fzmm.old_give.error", (Object[])new Object[]{item.toString(), oldVersion.method_15442()}).method_27692(class_124.field_1061);
            if (error.get() || result.isEmpty() || ((class_1799)result.get()).method_7960()) {
                chatHud.method_1812((class_2561)errorMessage);
            } else {
                FzmmUtils.giveItem(FzmmUtils.processStack((class_1799)result.get()));
                chatHud.method_1812((class_2561)class_2561.method_43469((String)"commands.fzmm.old_give.success", (Object[])new Object[]{item.toString(), oldVersion.method_15442()}).method_54663(4689479));
            }
        });
    }

    @NotNull
    private static class_2487 getFakeHotbarStorageCompound(String item, int damage, class_2487 nbtCompound, int oldVersion) {
        class_2487 fakeHotbarStorageCompound = new class_2487();
        try {
            for (int i = 0; i < 9; ++i) {
                class_2499 entry = new class_2499();
                if (i == 0) {
                    class_2487 itemCompound = new class_2487();
                    itemCompound.method_10567("Count", (byte)1);
                    itemCompound.method_10582("id", item);
                    itemCompound.method_10566("tag", (class_2520)nbtCompound);
                    if (oldVersion <= (Integer)VersionArgumentType.parse("1.12.2").method_15441()) {
                        itemCompound.method_10569("Damage", damage);
                    }
                    entry.add((Object)itemCompound);
                }
                for (int j = entry.size(); j != 9; ++j) {
                    class_2487 emptyCompound = new class_2487();
                    emptyCompound.method_10567("Count", (byte)1);
                    emptyCompound.method_10582("id", "minecraft:air");
                    entry.add((Object)emptyCompound);
                }
                fakeHotbarStorageCompound.method_10566(String.valueOf(i), (class_2520)entry);
            }
        }
        catch (CommandSyntaxException e) {
            FzmmClient.LOGGER.error("[FzmmCommand] Failed to get fake hotbar storage compound", (Throwable)e);
            return new class_2487();
        }
        return fakeHotbarStorageCompound;
    }

    private static void addEnchant(class_1887 enchant, short level) {
        class_1799 stack = FzmmUtils.getHandStack(class_1268.field_5808);
        class_2487 tag = stack.method_7948();
        class_2499 enchantments = new class_2499();
        if (tag.method_10573("Enchantments", 9)) {
            enchantments = tag.method_10554("Enchantments", 10);
        }
        enchantments.add((Object)class_1890.method_37426((class_2960)class_1890.method_37423((class_1887)enchant), (int)level));
        tag.method_10566("Enchantments", (class_2520)enchantments);
        stack.method_7980(tag);
        FzmmUtils.giveItem(stack);
    }

    private static void addFakeEnchant(class_1887 enchant, int level) {
        assert (class_310.method_1551().field_1724 != null);
        class_1799 stack = class_310.method_1551().field_1724.method_31548().method_7391();
        class_5250 enchantMessage = (class_5250)enchant.method_8179(level);
        class_2583 style = enchantMessage.method_10866().method_10978(Boolean.valueOf(false));
        enchantMessage.method_10855().forEach(text -> {
            if (!text.getString().isBlank()) {
                ((class_5250)text).method_10862(style);
            }
        });
        stack = DisplayBuilder.of(stack).addLore((class_2561)enchantMessage).get();
        class_2487 tag = stack.method_7948();
        if (!tag.method_10573("Enchantments", 9)) {
            class_2499 enchantments = new class_2499();
            enchantments.add((Object)new class_2487());
            tag.method_10566("Enchantments", (class_2520)enchantments);
        }
        FzmmUtils.giveItem(stack);
    }

    private static void showNbt(CommandContext<FabricClientCommandSource> ctx) {
        class_5250 nbtMessage;
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        class_1799 stack = client.field_1724.method_31548().method_7391();
        if (!stack.method_7985()) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.fzmm.item.withoutNbt"));
            return;
        }
        assert (stack.method_7969() != null);
        int MAX_CHAT_LINES = 90;
        int MAX_HOVER_LENGTH = 15000;
        String nbtString = stack.method_7969().toString();
        Object nbtStringHover = nbtString;
        int nbtLength = nbtString.length();
        if (client.field_1772.method_1727(nbtString) > class_338.method_1806((double)((Double)client.field_1690.method_42556().method_41753())) * 90) {
            String message = String.format("[%s]", class_2561.method_43471((String)"commands.fzmm.nbt.tooLong").getString());
            nbtMessage = class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_36139(0xB7B7B7));
        } else {
            nbtMessage = class_2512.method_32270((class_2520)stack.method_7969()).method_27661();
        }
        if (nbtLength > 15000) {
            nbtStringHover = "..." + ((String)nbtStringHover).substring(nbtLength - 15000, nbtLength);
        }
        class_5250 clickToCopyMessage = class_2561.method_43470((String)" (").method_10852((class_2561)class_2561.method_43471((String)"commands.fzmm.nbt.click")).method_27693(")").method_10862(class_2583.field_24360.method_36139(0xB7B7B7));
        class_5250 message = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)stack.method_7909().toString()).method_10862(class_2583.field_24360.method_36139(4689479))).method_10852((class_2561)nbtMessage.method_27661().method_10862(nbtMessage.method_10866().method_10958(new class_2558(class_2558.class_2559.field_21462, nbtString)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)nbtStringHover)))).method_10852((class_2561)clickToCopyMessage));
        class_5250 length = class_2561.method_43470((String)String.valueOf(nbtLength)).method_10862(class_2583.field_24360.method_36139(0xB7B7B7));
        class_5250 lengthMessage = class_2561.method_43469((String)"commands.fzmm.nbt.length", (Object[])new Object[]{length}).method_10862(class_2583.field_24360.method_36139(4689479));
        client.field_1705.method_1743().method_1812((class_2561)message.method_27693("\n").method_10852((class_2561)lengthMessage));
    }

    private static void amount(int amount) {
        class_1799 stack = FzmmUtils.getHandStack(class_1268.field_5808);
        stack.method_7939(amount);
        FzmmUtils.updateHand(stack);
    }

    private static void getHead(GetSkinDecorator skinDecorator, String playerName) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        Optional<class_1799> optionalStack = skinDecorator.getHead(playerName);
        FzmmUtils.giveItem(optionalStack.orElseGet(() -> {
            FzmmClient.LOGGER.warn("[FzmmCommand] Could not get head for {}", (Object)playerName);
            return class_1802.field_8575.method_7854();
        }));
    }

    private static void fullContainer(int slotsToFill, int firstSlot) {
        class_1799 containerStack = FzmmUtils.getHandStack(class_1268.field_5808);
        class_1799 itemStack = FzmmUtils.getHandStack(class_1268.field_5810);
        class_2487 nbt = containerStack.method_7948();
        class_2487 blockEntityTag = new class_2487();
        class_2499 containerItems = nbt.method_10562("BlockEntityTag").method_10554("Items", 10);
        if (firstSlot == -1) {
            FzmmCommand.fullContainerEmptySlots(containerItems, itemStack, slotsToFill);
        } else {
            FzmmCommand.fullContainer(containerItems, itemStack, slotsToFill, firstSlot);
        }
        for (int i = 0; i < containerItems.size(); ++i) {
            class_1799 stack = class_1799.method_7915((class_2487)containerItems.method_10602(i));
            if (!stack.method_7960() && containerItems.method_10602(i).method_10550("Slot") < 27) continue;
            containerItems.method_10536(i);
            --i;
        }
        blockEntityTag.method_10566("Items", (class_2520)containerItems);
        blockEntityTag.method_10582("id", containerStack.method_7909().toString());
        nbt.method_10566("BlockEntityTag", (class_2520)blockEntityTag);
        containerStack.method_7980(nbt);
        FzmmUtils.giveItem(containerStack);
    }

    private static void fullContainer(class_2499 stackList, class_1799 stack, int slotsToFill, int firstSlot) {
        int i;
        int finalSlot = firstSlot + slotsToFill;
        if (finalSlot > stackList.size()) {
            for (i = stackList.size(); i < finalSlot; ++i) {
                stackList.add((Object)InventoryUtils.getSlotTag(class_1799.field_8037, i));
            }
        }
        for (i = firstSlot; i != finalSlot; ++i) {
            stackList.method_10606(i, (class_2520)InventoryUtils.getSlotTag(stack, i));
        }
    }

    private static void fullContainerEmptySlots(class_2499 stackList, class_1799 stack, int slotsToFill) {
        int i;
        int finalSlot = Math.min(stackList.size() + slotsToFill, 27);
        if (finalSlot > stackList.size()) {
            for (i = stackList.size(); i < finalSlot; ++i) {
                stackList.add((Object)InventoryUtils.getSlotTag(class_1799.field_8037, i));
            }
        }
        for (i = 0; i != finalSlot; ++i) {
            if (class_1799.method_7915((class_2487)stackList.method_10602(i)).method_7960()) {
                stackList.method_10606(i, (class_2520)InventoryUtils.getSlotTag(stack, i));
                --slotsToFill;
            }
            if (slotsToFill == 0) break;
        }
    }

    private static void lockContainer(String key) {
        class_310 client = class_310.method_1551();
        class_1799 containerStack = FzmmUtils.getHandStack(class_1268.field_5808);
        class_1799 lockStack = FzmmUtils.getHandStack(class_1268.field_5810);
        class_2487 tag = new class_2487();
        class_2487 blockEntityTag = new class_2487();
        if (containerStack.method_7985() || tag.method_10573("BlockEntityTag", 10)) {
            tag = containerStack.method_7969();
            assert (tag != null);
            if (tag.method_10573("BlockEntityTag", 10)) {
                tag.method_10562("BlockEntityTag").method_10582("Lock", key);
            }
        } else {
            blockEntityTag.method_10582("Lock", key);
            tag.method_10566("BlockEntityTag", (class_2520)blockEntityTag);
        }
        containerStack.method_7980(tag);
        lockStack.method_7977((class_2561)class_2561.method_43470((String)key));
        FzmmUtils.giveItem(containerStack);
        assert (client.field_1761 != null);
        client.field_1761.method_2909(lockStack, 36 + class_1661.method_7368());
    }

    private static void removeLore() {
        class_1799 stack = FzmmUtils.getHandStack(class_1268.field_5808);
        class_2487 display = stack.method_7911("display");
        if (display.method_10573("Lore", 9)) {
            FzmmCommand.removeLore(display.method_10554("Lore", 8).size() - 1);
        }
    }

    private static void removeLore(int lineToRemove) {
        class_1799 stack = FzmmUtils.getHandStack(class_1268.field_5808);
        class_2487 display = stack.method_7911("display");
        if (!display.method_10573("Lore", 9)) {
            return;
        }
        class_2499 lore = display.method_10554("Lore", 8);
        if (lore.size() < lineToRemove) {
            return;
        }
        lore.method_10536(lineToRemove);
        display.method_10566("Lore", (class_2520)lore);
        stack.method_7959("display", (class_2520)display);
        FzmmUtils.giveItem(stack);
    }

    private static void swapItemWithHand(class_1304 slot) {
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        assert (client.field_1761 != null);
        class_746 player = client.field_1724;
        if (!FzmmUtils.isAllowedToGive()) {
            FzmmClient.LOGGER.warn("[FzmmCommand] Creative mode is necessary to swap items");
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"fzmm.item.error.actionNotAllowed").method_10862(class_2583.field_24360.method_36139(4689479)));
            return;
        }
        class_1661 inventory = player.method_31548();
        class_1799 handStack = player.method_6047();
        class_1799 armorStack = player.method_6118(slot);
        int armorSlotId = Math.abs(slot.method_32320(0) - 3) + 5;
        client.field_1761.method_2909(handStack, armorSlotId);
        client.field_1761.method_2909(armorStack, 36 + inventory.field_7545);
    }
}

