/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.utils.FzmmUtils;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SignBuilder {
    public static final int MAX_ROWS = 4;
    private class_1799 stack = class_1802.field_8788.method_7854();
    private final class_2499 frontTextList = new class_2499();
    private final class_2487 frontCompound = new class_2487();
    private final class_2499 backTextList = new class_2499();
    private final class_2487 backCompound = new class_2487();
    private boolean isWaxed = false;

    private SignBuilder() {
    }

    public static SignBuilder builder() {
        return new SignBuilder();
    }

    public SignBuilder item(class_1792 item) {
        this.stack = item.method_7854();
        return this;
    }

    public SignBuilder addFrontLine(class_2519 nbtString) {
        return this.addLine(this.frontTextList, nbtString);
    }

    public SignBuilder addBackLine(class_2519 nbtString) {
        return this.addLine(this.backTextList, nbtString);
    }

    private SignBuilder addLine(class_2499 list, class_2519 nbtString) {
        list.add((Object)nbtString);
        return this;
    }

    public SignBuilder addFrontLine(class_2561 text, int expectedWidth) {
        return this.addLine(this.frontTextList, text, expectedWidth);
    }

    public SignBuilder addBackLine(class_2561 text, int expectedWidth) {
        return this.addLine(this.backTextList, text, expectedWidth);
    }

    private SignBuilder addLine(class_2499 list, class_2561 text, int expectedWidth) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        assert (class_310.method_1551().field_1724 != null);
        if (text == null) {
            return this;
        }
        class_5250 textCopy = text.method_27661();
        int spaceCount = 0;
        while (textRenderer.method_27525((class_5348)textCopy) < expectedWidth) {
            textCopy.method_27693(" ");
            ++spaceCount;
        }
        class_2519 nbtString = FzmmUtils.toNbtString((class_2561)text.method_27661().method_27693(" ".repeat(spaceCount)), false);
        list.add((Object)nbtString);
        return this;
    }

    public SignBuilder glowingFront() {
        return this.glowing(this.frontCompound);
    }

    public SignBuilder glowingBack() {
        return this.glowing(this.backCompound);
    }

    private SignBuilder glowing(class_2487 compound) {
        compound.method_10556("has_glowing_text", true);
        return this;
    }

    public SignBuilder colorFront(String color) {
        return this.color(this.frontCompound, color);
    }

    public SignBuilder colorBack(String color) {
        return this.color(this.backCompound, color);
    }

    private SignBuilder color(class_2487 compound, String color) {
        compound.method_10582("color", color);
        return this;
    }

    public SignBuilder wax() {
        this.isWaxed = true;
        return this;
    }

    public class_1799 get() {
        class_2487 entityTag = new class_2487();
        if (!this.frontTextList.isEmpty()) {
            while (this.frontTextList.size() < 4) {
                this.frontTextList.add((Object)class_2519.method_23256((String)"\"\""));
            }
            this.frontCompound.method_10566("messages", (class_2520)this.frontTextList);
            entityTag.method_10566("front_text", (class_2520)this.frontCompound);
        }
        if (!this.backTextList.isEmpty()) {
            while (this.backTextList.size() < 4) {
                this.backTextList.add((Object)class_2519.method_23256((String)"\"\""));
            }
            this.backCompound.method_10566("messages", (class_2520)this.backTextList);
            entityTag.method_10566("back_text", (class_2520)this.backCompound);
        }
        entityTag.method_10556("is_waxed", this.isWaxed);
        this.stack.method_7959("BlockEntityTag", (class_2520)entityTag);
        return this.stack;
    }

    private void addSignMessage(List<class_2561> list, class_2487 compound, class_2487 blockEntityTag, String key) {
        if (list.isEmpty()) {
            return;
        }
        while (list.size() < 4) {
            list.add((class_2561)class_2561.method_43473());
        }
        class_2499 listTag = new class_2499();
        listTag.addAll(list.stream().map(text -> {
            String textJson = class_2561.class_2562.method_10867((class_2561)text);
            return class_2519.method_23256((String)textJson);
        }).toList());
        compound.method_10566("messages", (class_2520)listTag);
        blockEntityTag.method_10566(key, (class_2520)compound);
    }
}

