/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.builders.DisplayBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ContainerBuilder {
    private final List<class_1799> itemList = new ArrayList<class_1799>();
    private class_1792 containerItem = class_1802.field_8722;
    private int maxItemByContainer = 27;

    private ContainerBuilder() {
    }

    public static ContainerBuilder builder() {
        return new ContainerBuilder();
    }

    public ContainerBuilder containerItem(class_1792 item) {
        this.containerItem = item;
        return this;
    }

    public ContainerBuilder maxItemByContainer(int value) {
        this.maxItemByContainer = value;
        return this;
    }

    public List<class_1799> getAsList() {
        List<class_2499> itemsTagList = this.getItemsTagList();
        ArrayList<class_1799> containerList = new ArrayList<class_1799>();
        for (class_2499 itemTag : itemsTagList) {
            class_2487 blockEntityTag = new class_2487();
            blockEntityTag.method_10566("Items", (class_2520)itemTag);
            class_1799 stack = this.containerItem.method_7854();
            stack.method_7959("BlockEntityTag", (class_2520)blockEntityTag);
            containerList.add(stack);
        }
        return containerList;
    }

    public List<class_2499> getItemsTagList() {
        ArrayList<class_2499> itemsTagList = new ArrayList<class_2499>();
        int containersAmount = (int)Math.ceil((float)this.itemList.size() / (float)this.maxItemByContainer);
        for (int i = 0; i != containersAmount; ++i) {
            int sublistEnd = Math.min((i + 1) * this.maxItemByContainer, this.itemList.size());
            List<class_1799> stackSublist = this.itemList.subList(i * this.maxItemByContainer, sublistEnd);
            itemsTagList.add(this.getItemsTag(stackSublist));
        }
        return itemsTagList;
    }

    public class_2499 getItemsTag(List<class_1799> stackList) {
        class_2499 itemsTag = new class_2499();
        for (int i = 0; i != stackList.size(); ++i) {
            class_2487 tag = stackList.get(i).method_7953(new class_2487());
            tag.method_10567("Slot", (byte)i);
            itemsTag.add((Object)tag);
        }
        return itemsTag;
    }

    public ContainerBuilder add(class_1799 stack) {
        return this.addAll(List.of(stack));
    }

    public ContainerBuilder addAll(List<class_1799> stacks) {
        this.itemList.addAll(stacks);
        return this;
    }

    public ContainerBuilder addLoreToItems(class_1792 itemToApply, String lore, int color) {
        for (class_1799 stack : this.itemList) {
            if (stack.method_7909() != itemToApply) continue;
            class_2487 tag = DisplayBuilder.of(stack).addLore(lore, color).getNbt();
            stack.method_7980(tag);
        }
        return this;
    }

    public ContainerBuilder setNameStyleToItems(class_2583 style) {
        for (class_1799 stack : this.itemList) {
            Optional<String> optionalName = DisplayBuilder.of(stack).getName();
            if (optionalName.isEmpty()) continue;
            String name = optionalName.get();
            try {
                class_5250 nameText = class_2561.class_2562.method_10877((String)name);
                if (nameText == null) {
                    nameText = class_2561.method_43470((String)name);
                }
                nameText = nameText.method_27661();
                nameText.method_10862(style);
                stack.method_7977((class_2561)nameText);
            }
            catch (Exception exception) {}
        }
        return this;
    }
}

