/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.builders;

import fzmm.zailer.me.utils.FzmmUtils;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class BookBuilder {
    private boolean resolved = false;
    private final class_2499 pages = new class_2499();
    private int generation = 0;
    private String author;
    private String title;

    private BookBuilder() {
        assert (class_310.method_1551().field_1724 != null);
        this.author = class_310.method_1551().field_1724.method_5477().getString();
        this.title = null;
    }

    public static BookBuilder builder() {
        return new BookBuilder();
    }

    public static Optional<BookBuilder> of(class_1799 book) {
        if (!(book = book.method_7972()).method_7909().equals(class_1802.field_8360) || !book.method_7985()) {
            return Optional.empty();
        }
        class_2487 tag = book.method_7969();
        assert (tag != null);
        String title = tag.method_10558("title");
        String author = tag.method_10558("author");
        boolean resolved = tag.method_10577("resolved");
        int generation = tag.method_10550("generation");
        class_2499 pages = tag.method_10554("pages", 8);
        return Optional.of(BookBuilder.builder().title(title).author(author).resolved(resolved).generation(generation).addPages(pages));
    }

    public BookBuilder addPage(class_2519 text) {
        this.pages.add((Object)text);
        return this;
    }

    public BookBuilder addPage(class_2561 text) {
        this.addPage(FzmmUtils.toNbtString(text, false));
        return this;
    }

    public BookBuilder addPages(class_2499 pages) {
        this.pages.addAll((Collection)pages);
        return this;
    }

    public BookBuilder title(String title) {
        this.title = title;
        return this;
    }

    public BookBuilder author(String author) {
        this.author = author;
        return this;
    }

    public BookBuilder resolved(boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    public BookBuilder generation(int generation) {
        this.generation = generation;
        return this;
    }

    public class_1799 get() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        class_2487 tag = new class_2487();
        tag.method_10556("resolved", this.resolved);
        tag.method_10566("pages", (class_2520)this.pages);
        tag.method_10569("generation", this.generation);
        tag.method_10582("author", this.author);
        if (this.title != null) {
            if (this.title.length() > 32) {
                this.title = this.title.substring(0, 32);
            }
            tag.method_10582("title", this.title);
        }
        stack.method_7980(tag);
        return stack;
    }
}

