/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.aps.client.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.gitlab.jfronny.aps.client.impl.ResourcePackOrganizerLockState;
import io.gitlab.jfronny.aps.client.impl.SafeCloseable;
import io.gitlab.jfronny.libjf.LibJf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.resource.loader.FabricResourcePackProfile;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_5369.class})
public abstract class ResourcePackOrganizerMixin {
    @Shadow
    @Final
    private class_3283 field_25626;
    @Shadow
    @Final
    List<class_3288> field_25455;
    @Shadow
    @Final
    List<class_3288> field_25456;
    @Unique
    private Future<Void> aps$packScan = null;
    @Unique
    private final ResourcePackOrganizerLockState aps$lock = new ResourcePackOrganizerLockState();

    @Overwrite
    public void method_29981() {
        if (this.aps$lock.requestScan().shouldStart()) {
            this.aps$startScan();
        }
    }

    @Unique
    private void aps$startScan() {
        Future[] tasks = new Future[1];
        this.aps$packScan = tasks[0] = this.field_25626.scanPacksAsync(() -> this.aps$afterScan(tasks[0]));
    }

    @Unique
    private void aps$afterScan(Future<Void> task) {
        try (SafeCloseable lock = this.aps$lock.lockResources();){
            if (task.isCancelled()) {
                return;
            }
            this.field_25455.retainAll(this.field_25626.method_14441());
            this.field_25456.clear();
            this.field_25456.addAll(this.field_25626.method_14441());
            this.field_25456.removeAll(this.field_25455);
            this.filterFabricPacks(this.field_25455);
            this.filterFabricPacks(this.field_25456);
            if (this.aps$packScan == task) {
                this.aps$packScan = null;
            }
        }
        if (this.aps$lock.emitScanFinished().shouldContinue()) {
            this.aps$startScan();
        }
    }

    @Unique
    private void filterFabricPacks(List<class_3288> list) {
        list.removeIf(profile -> {
            FabricResourcePackProfile prpp;
            return profile instanceof FabricResourcePackProfile && (prpp = (FabricResourcePackProfile)profile).fabric_isHidden();
        });
    }

    @Overwrite
    public void method_49627() {
        try {
            if (this.aps$packScan != null) {
                this.aps$packScan.get();
            }
            try (SafeCloseable lock = this.aps$lock.lockResources();){
                this.field_25626.method_14447((Collection)Lists.reverse(this.field_25455).stream().map(class_3288::method_14463).collect(ImmutableList.toImmutableList()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LibJf.LOGGER.error("Pack scan was interrupted", (Throwable)e);
        }
    }

    @Overwrite
    public Stream<class_5369.class_5371> method_29639() {
        try (SafeCloseable lock = this.aps$lock.lockResources();){
            Stream<class_5369.class_5371> stream = this.field_25456.stream().map(pack -> {
                class_5369 class_53692 = (class_5369)this;
                Objects.requireNonNull(class_53692);
                return new class_5369.class_5374(class_53692, pack);
            }).toList().stream();
            return stream;
        }
    }

    @Overwrite
    public Stream<class_5369.class_5371> method_29643() {
        try (SafeCloseable lock = this.aps$lock.lockResources();){
            Stream<class_5369.class_5371> stream = this.field_25455.stream().map(pack -> {
                class_5369 class_53692 = (class_5369)this;
                Objects.requireNonNull(class_53692);
                return new class_5369.class_5373(class_53692, pack);
            }).toList().stream();
            return stream;
        }
    }
}

