/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.aps.client.impl;

import io.gitlab.jfronny.aps.client.impl.SafeCloseable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ResourcePackOrganizerLockState {
    private final Lock resourcesLock = new ReentrantLock();
    private boolean isRunning = false;
    private boolean isScheduled = false;
    private final Lock scanStateLock = new ReentrantLock();

    public SafeCloseable lockResources() {
        this.resourcesLock.lock();
        return this.resourcesLock::unlock;
    }

    public ScanFinishedResponse emitScanFinished() {
        this.scanStateLock.lock();
        try {
            if (this.isScheduled) {
                this.isScheduled = false;
                ScanFinishedResponse scanFinishedResponse = new ScanFinishedResponse(true);
                return scanFinishedResponse;
            }
            this.isRunning = false;
            ScanFinishedResponse scanFinishedResponse = new ScanFinishedResponse(false);
            return scanFinishedResponse;
        }
        finally {
            this.scanStateLock.unlock();
        }
    }

    public RequestScanResponse requestScan() {
        this.scanStateLock.lock();
        try {
            if (this.isRunning) {
                this.isScheduled = true;
                RequestScanResponse requestScanResponse = new RequestScanResponse(false);
                return requestScanResponse;
            }
            this.isRunning = true;
            RequestScanResponse requestScanResponse = new RequestScanResponse(true);
            return requestScanResponse;
        }
        finally {
            this.scanStateLock.unlock();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ScanFinishedResponse(boolean shouldContinue) {
    }

    @Environment(value=EnvType.CLIENT)
    public record RequestScanResponse(boolean shouldStart) {
    }
}

