/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.sound;

import de.keksuccino.konkrete.platform.Services;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public class SoundHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, Clip> sounds = new HashMap<String, Clip>();
    private static boolean init = false;
    private static volatile boolean volumeHandling = true;
    private static List<String> unsupportedFormatAudios = new ArrayList<String>();

    public static void init() {
        if (!Services.PLATFORM.isOnClient()) {
            LOGGER.error("[KONKRETE] Tried to initialize SoundHandler server-side!", (Throwable)new IllegalStateException("Cannot initialize SoundHandler on server."));
            return;
        }
        if (!init) {
            new Thread(() -> {
                float lastMaster = 0.0f;
                while (volumeHandling) {
                    try {
                        if (class_310.method_1551() != null && class_310.method_1551().field_1690 != null) {
                            float currentMaster = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
                            if (lastMaster != currentMaster) {
                                SoundHandler.updateVolume();
                            }
                            lastMaster = currentMaster;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            init = true;
        }
    }

    public static void registerSound(String key, String path) {
        if (unsupportedFormatAudios.contains(key)) {
            return;
        }
        if (!Services.PLATFORM.isOnClient()) {
            LOGGER.error("[KONKRETE] Tried to register sound server-side!", (Throwable)new IllegalStateException("Cannot registers sounds to SoundHandler on server."));
            return;
        }
        if (!sounds.containsKey(key)) {
            AudioInputStream in = null;
            try {
                Clip c = AudioSystem.getClip();
                in = AudioSystem.getAudioInputStream(new File(path));
                c.open(in);
                in.close();
                sounds.put(key, c);
                SoundHandler.setVolume(key, SoundHandler.getMinecraftMasterVolume());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("[KONKRETE] Unable to register sound! Format not supported or invalid!");
                SoundHandler.printErrorLog(e, key, 0, "registering audio");
                unsupportedFormatAudios.add(key);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                sounds.remove(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                sounds.remove(key);
            }
        }
    }

    public static void unregisterSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).stop();
            sounds.get(key).close();
            sounds.remove(key);
        }
    }

    public static void playSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).start();
        }
    }

    public static void stopSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).stop();
        }
    }

    public static void resetSound(String key) {
        if (sounds.containsKey(key)) {
            sounds.get(key).setMicrosecondPosition(0L);
        }
    }

    public static boolean soundExists(String key) {
        return sounds.containsKey(key);
    }

    public static void setLooped(String key, boolean looped) {
        if (sounds.containsKey(key)) {
            Clip c = sounds.get(key);
            if (looped) {
                c.setLoopPoints(0, -1);
                c.loop(-1);
            } else {
                c.loop(0);
            }
        }
    }

    public static boolean isPlaying(String key) {
        return sounds.containsKey(key) && sounds.get(key).isRunning();
    }

    public static void updateVolume() {
        for (String s : sounds.keySet()) {
            SoundHandler.setVolume(s, SoundHandler.getMinecraftMasterVolume());
        }
    }

    private static void setVolume(String key, int percentage) {
        if (!volumeHandling) {
            return;
        }
        try {
            if (sounds.containsKey(key)) {
                Clip clip = sounds.get(key);
                if (clip.isOpen()) {
                    if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                        FloatControl f = (FloatControl)sounds.get(key).getControl(FloatControl.Type.MASTER_GAIN);
                        int gain = (int)((float)((int)f.getMinimum()) + (f.getMaximum() - f.getMinimum()) / 100.0f * (float)percentage);
                        f.setValue(gain);
                    } else {
                        volumeHandling = false;
                        LOGGER.error("[KONKRETE] Unable to set sound volume! MASTER_GAIN control not supported! Disabling volume handling!");
                        SoundHandler.printErrorLog(new Throwable(), key, percentage, "setting volume");
                    }
                } else {
                    LOGGER.error("[KONKRETE] Unable to set sound volume! Clip not open: " + key);
                }
            }
        }
        catch (Exception e) {
            volumeHandling = false;
            LOGGER.error("[KONKRETE] Unable to set sound volume! Disabling volume handling!");
            SoundHandler.printErrorLog(e, key, percentage, "setting volume");
        }
    }

    private static void printErrorLog(Throwable throwable, String audioKey, int audioVolume, String action) {
        class_128 c = class_128.method_560((Throwable)throwable, (String)("Exception in Konkrete while " + action));
        class_129 cat = c.method_562("Audio Information");
        cat.method_578("Key", (Object)audioKey);
        cat.method_578("Volume", (Object)audioVolume);
        LOGGER.error(c.method_568());
    }

    private static int getMinecraftMasterVolume() {
        return (int)(class_310.method_1551().field_1690.method_1630(class_3419.field_15250) * 100.0f);
    }
}

