/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import it.unimi.dsi.fastutil.longs.LongArrays;
import java.nio.ByteBuffer;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import me.jellysquid.mods.sodium.client.gl.util.VertexRange;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryUtil;

public class SodiumResultCompatibility {
    public static RepackagedSectionOutput repackage(ChunkBuildOutput result) {
        int formatSize = 16;
        int geometryBytes = result.meshes.values().stream().mapToInt(a -> a.getVertexData().getLength()).sum();
        NativeBuffer output = new NativeBuffer(geometryBytes);
        short[] offsets = new short[8];
        Vector3i min = new Vector3i(2000);
        Vector3i max = new Vector3i(-2000);
        SodiumResultCompatibility.packageSectionGeometry(formatSize, output, offsets, result, min, max);
        min.x = Math.max(min.x, 0);
        min.y = Math.max(min.y, 0);
        min.z = Math.max(min.z, 0);
        min.x = Math.min(min.x, 15);
        min.y = Math.min(min.y, 15);
        min.z = Math.min(min.z, 15);
        max.x = Math.min(max.x, 16);
        max.y = Math.min(max.y, 16);
        max.z = Math.min(max.z, 16);
        max.x = Math.max(max.x, 0);
        max.y = Math.max(max.y, 0);
        max.z = Math.max(max.z, 0);
        Vector3i size = new Vector3i(max.x - min.x - 1, max.y - min.y - 1, max.z - min.z - 1);
        size.x = Math.min(15, Math.max(size.x, 0));
        size.y = Math.min(15, Math.max(size.y, 0));
        size.z = Math.min(15, Math.max(size.z, 0));
        RepackagedSectionOutput repackagedGeometry = new RepackagedSectionOutput(geometryBytes / formatSize / 4, output, offsets, min, size);
        return repackagedGeometry;
    }

    private static void copyQuad(long from, long too) {
        for (long i = 0L; i < 64L; i += 8L) {
            MemoryUtil.memPutLong((long)(too + i), (long)MemoryUtil.memGetLong((long)(from + i)));
        }
    }

    private static void packageSectionGeometry(int formatSize, NativeBuffer output, short[] outOffsets, ChunkBuildOutput result, Vector3i min, Vector3i max) {
        short flags;
        int offset = 0;
        long outPtr = MemoryUtil.memAddress((ByteBuffer)output.getDirectBuffer());
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        float cpx = (float)(cameraPos.field_1352 - (double)(result.render.getChunkX() << 4));
        float cpy = (float)(cameraPos.field_1351 - (double)(result.render.getChunkY() << 4));
        float cpz = (float)(cameraPos.field_1350 - (double)(result.render.getChunkZ() << 4));
        float len = (float)Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz);
        cpx *= 1.0f / len;
        cpy *= 1.0f / len;
        cpz *= 1.0f / len;
        len = Math.min(len, 32.0f);
        cpx *= len;
        cpy *= len;
        cpz *= len;
        BuiltSectionMeshParts translucentData = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT);
        if (translucentData != null) {
            int i;
            int quadCount = 0;
            for (int i2 = 0; i2 < 7; ++i2) {
                VertexRange part = translucentData.getVertexRanges()[i2];
                quadCount += part != null ? part.vertexCount() / 4 : 0;
            }
            int quadId = 0;
            long[] sortingData = new long[quadCount];
            long[] srcs = new long[7];
            for (i = 0; i < 7; ++i) {
                long src;
                VertexRange part = translucentData.getVertexRanges()[i];
                if (part == null) continue;
                srcs[i] = src = MemoryUtil.memAddress((ByteBuffer)translucentData.getVertexData().getDirectBuffer()) + (long)part.vertexStart() * (long)formatSize;
                float cx = 0.0f;
                float cy = 0.0f;
                float cz = 0.0f;
                for (int j = 0; j < part.vertexCount(); ++j) {
                    long base = src + (long)j * (long)formatSize;
                    flags = 4;
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags);
                    float x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)base));
                    float y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 2L)));
                    float z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 4L)));
                    SodiumResultCompatibility.updateSectionBounds(min, max, x, y, z);
                    cx += x;
                    cy += y;
                    cz += z;
                    if ((j & 3) != 3) continue;
                    float dx = (cx *= 0.25f) - cpx;
                    float dy = (cy *= 0.25f) - cpy;
                    float dz = (cz *= 0.25f) - cpz;
                    float dist = dx * dx + dy * dy + dz * dz;
                    int sortDistance = (int)(dist * 4096.0f);
                    long packedSortingData = (long)sortDistance << 32 | ((long)j >> 2 << 3 | (long)i);
                    sortingData[quadId++] = packedSortingData;
                    cx = 0.0f;
                    cy = 0.0f;
                    cz = 0.0f;
                }
            }
            if (quadId != sortingData.length) {
                throw new IllegalStateException();
            }
            LongArrays.radixSort((long[])sortingData);
            for (i = 0; i < sortingData.length; ++i) {
                long data = sortingData[i];
                SodiumResultCompatibility.copyQuad(srcs[(int)(data & 7L)] + (data >> 3 & 0x1FFFFFFFL) * 4L * (long)formatSize, outPtr + (long)(sortingData.length - 1 - i) * 4L * (long)formatSize);
            }
            offset += quadCount;
        }
        outOffsets[7] = (short)offset;
        BuiltSectionMeshParts solid = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.SOLID);
        BuiltSectionMeshParts cutout = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.CUTOUT);
        for (int i = 0; i < 7; ++i) {
            VertexRange part;
            long base;
            int j;
            long dst;
            long src;
            VertexRange part2;
            int poff = offset;
            if (solid != null && (part2 = solid.getVertexRanges()[i]) != null) {
                src = MemoryUtil.memAddress((ByteBuffer)solid.getVertexData().getDirectBuffer()) + (long)part2.vertexStart() * (long)formatSize;
                dst = outPtr + (long)offset * 4L * (long)formatSize;
                MemoryUtil.memCopy((long)src, (long)dst, (long)((long)part2.vertexCount() * (long)formatSize));
                for (j = 0; j < part2.vertexCount(); ++j) {
                    base = dst + (long)j * (long)formatSize;
                    short flags2 = 4;
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags2);
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                }
                offset += part2.vertexCount() / 4;
            }
            if (cutout != null && (part = cutout.getVertexRanges()[i]) != null) {
                src = MemoryUtil.memAddress((ByteBuffer)cutout.getVertexData().getDirectBuffer()) + (long)part.vertexStart() * (long)formatSize;
                dst = outPtr + (long)offset * 4L * (long)formatSize;
                MemoryUtil.memCopy((long)src, (long)dst, (long)((long)part.vertexCount() * (long)formatSize));
                for (j = 0; j < part.vertexCount(); ++j) {
                    base = dst + (long)j * (long)formatSize;
                    short sflags = MemoryUtil.memGetShort((long)(base + 6L));
                    short mipbits = (short)((sflags & 6) >> 1);
                    if (mipbits == 2 && IrisCheck.IRIS_LOADED) {
                        mipbits = 1;
                    }
                    flags = (short)((sflags & 1) << 2 | mipbits);
                    MemoryUtil.memPutShort((long)(base + 6L), (short)flags);
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                }
                offset += part.vertexCount() / 4;
            }
            outOffsets[i] = (short)(offset - poff);
        }
        if (offset * 4 * formatSize != output.getLength()) {
            throw new IllegalStateException();
        }
    }

    private static float decodePosition(short v) {
        return (float)Short.toUnsignedInt(v) * 4.8828125E-4f - 8.0f;
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, long vertex) {
        float x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)vertex));
        float y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 2L)));
        float z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 4L)));
        SodiumResultCompatibility.updateSectionBounds(min, max, x, y, z);
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, float x, float y, float z) {
        min.x = (int)Math.min((double)min.x, Math.floor(x));
        min.y = (int)Math.min((double)min.y, Math.floor(y));
        min.z = (int)Math.min((double)min.z, Math.floor(z));
        max.x = (int)Math.max((double)max.x, Math.ceil(x));
        max.y = (int)Math.max((double)max.y, Math.ceil(y));
        max.z = (int)Math.max((double)max.z, Math.ceil(z));
    }
}

