/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.potionsreglint.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.fabricmc.loader.api.FabricLoader;

public class TelluriumConfig {
    private static final String fileExtension = ".properties";

    public static class IllegalConfigValueException
    extends IllegalArgumentException {
        public IllegalConfigValueException() {
        }

        public IllegalConfigValueException(String s) {
            super(s);
        }

        public IllegalConfigValueException(String message, Throwable cause) {
            super(message, cause);
        }

        public IllegalConfigValueException(Throwable cause) {
            super(cause);
        }
    }

    public static class IntRangeConfigEntry
    extends ConfigEntry<Integer> {
        private final int minValue;
        private final int maxValue;

        private IntRangeConfigEntry(Builder parent, String key, int minValue, int maxValue, int defaultValue) {
            super(parent, key, defaultValue);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        @Override
        public void setValue(Integer value) {
            if (value < this.minValue) {
                super.setValue(this.minValue);
            } else if (value > this.maxValue) {
                super.setValue(this.maxValue);
            } else {
                super.setValue(value);
            }
        }

        public IntRangeConfigEntry comment(String comment) {
            super.comment(comment);
            return this;
        }
    }

    public static class ConfigEntry<T> {
        private final Builder builder;
        private String comment;
        private final String key;
        private final T defaultValue;
        private T value;

        private ConfigEntry(Builder parent, String key, T defaultValue) {
            this.builder = parent;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String getKey() {
            return this.key;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public T getValue() {
            if (this.value == null || this.value.toString().isBlank()) {
                return this.defaultValue;
            }
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public ConfigEntry<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        private String getComment() {
            return this.comment;
        }
    }

    public static class Builder {
        private final String file;
        private final List<String> COMMENTS = new ArrayList<String>();
        private final List<ConfigEntry> ENTRIES = new ArrayList<ConfigEntry>();

        public Builder(String fileName) {
            this.file = FabricLoader.getInstance().getConfigDir().resolve(fileName + TelluriumConfig.fileExtension).toString();
        }

        public String getConfigFilePath() {
            return this.file;
        }

        public Builder comment(String comment) {
            this.COMMENTS.add(comment);
            return this;
        }

        public ConfigEntry<Boolean> define(String key, boolean defaultValue) {
            ConfigEntry<Boolean> newEntry = new ConfigEntry<Boolean>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Integer> define(String key, int defaultValue) {
            ConfigEntry<Integer> newEntry = new ConfigEntry<Integer>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public IntRangeConfigEntry defineInRange(String key, int minValue, int maxValue, int defaultValue) {
            IntRangeConfigEntry newEntry = new IntRangeConfigEntry(this, key, minValue, maxValue, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Double> define(String key, double defaultValue) {
            ConfigEntry<Double> newEntry = new ConfigEntry<Double>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Long> define(String key, long defaultValue) {
            ConfigEntry<Long> newEntry = new ConfigEntry<Long>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<String> define(String key, String defaultValue) {
            ConfigEntry<String> newEntry = new ConfigEntry<String>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public void build() throws IOException {
            File file = new File(this.file);
            if (file.exists()) {
                this.load();
            }
            this.save();
        }

        public void save() throws IOException {
            FileWriter writer = new FileWriter(this.file);
            String newline = System.lineSeparator();
            if (this.COMMENTS.size() > 0) {
                for (String s : this.COMMENTS) {
                    writer.write("#" + s + newline);
                }
            }
            writer.write(newline);
            writer.write("[Settings]" + newline);
            writer.write(newline);
            if (this.ENTRIES.size() > 0) {
                for (ConfigEntry entry : this.ENTRIES) {
                    String entrySeparator = "=";
                    if (entry.getComment() != null) {
                        writer.write("# " + entry.getComment() + newline);
                    }
                    if (entry instanceof IntRangeConfigEntry) {
                        writer.write("# Range: min=" + ((IntRangeConfigEntry)entry).getMinValue() + ", max=" + ((IntRangeConfigEntry)entry).getMaxValue() + newline);
                    }
                    writer.write("# default = " + entry.getDefaultValue() + newline);
                    writer.write(entry.getKey() + entrySeparator + entry.getValue() + newline);
                    writer.write(newline);
                }
            }
            writer.flush();
            writer.close();
        }

        private void load() throws IOException {
            File file = new File(this.file);
            Scanner reader = new Scanner(file);
            int line = 1;
            while (reader.hasNextLine()) {
                this.parseConfigEntry(reader.nextLine(), line);
                ++line;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseConfigEntry(String string, int line) {
            if (!this.isValueLine(string)) return;
            String[] entryParts = string.split("=", 2);
            if (entryParts.length != 2) throw new IllegalConfigValueException("Syntax error in config file \"" + this.getConfigFilePath() + "\" on line " + line);
            ConfigEntry<?> configEntry = this.getConfigEntry(entryParts[0]);
            if (configEntry == null) throw new IllegalConfigValueException("Syntax error in config file \"" + this.getConfigFilePath() + "\" on line " + line);
            try {
                if (configEntry.getValue() instanceof Boolean) {
                    configEntry.setValue(Boolean.parseBoolean(entryParts[1]));
                    return;
                }
                if (configEntry.getValue() instanceof Integer) {
                    configEntry.setValue(Integer.parseInt(entryParts[1]));
                    return;
                }
                if (configEntry.getValue() instanceof Double) {
                    configEntry.setValue(Double.parseDouble(entryParts[1]));
                    return;
                }
                if (configEntry.getValue() instanceof Long) {
                    configEntry.setValue(Long.parseLong(entryParts[1]));
                    return;
                }
                if (!(configEntry.getValue() instanceof String)) return;
                configEntry.setValue(String.valueOf(entryParts[1]));
                return;
            }
            catch (NumberFormatException e) {
                configEntry.setValue(configEntry.getDefaultValue());
            }
        }

        private ConfigEntry<?> getConfigEntry(String key) {
            for (ConfigEntry entry : this.ENTRIES) {
                if (!entry.getKey().equals(key)) continue;
                return entry;
            }
            return null;
        }

        private boolean isValueLine(String line) {
            if (line.isEmpty()) {
                return false;
            }
            return !line.startsWith("#") && !line.startsWith("[");
        }
    }
}

