/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.tracker;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_640;
import net.minecraft.class_742;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.radar.tracker.PlayerTrackerIconRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElement;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementCollector;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementReader;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public class_2960 getPlayerSkin(class_1657 player, class_640 info) {
        class_2960 skinTextureLocation;
        class_2960 class_29602 = skinTextureLocation = player instanceof class_742 ? ((class_742)player).method_52814().comp_1626() : info.method_52810().comp_1626();
        if (skinTextureLocation == null) {
            skinTextureLocation = class_1068.method_4648((UUID)player.method_5667()).comp_1626();
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer = renderTypeBuffers.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_NEAREST);
        if (this.modMain.getSupportMods().worldmap()) {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = this.modMain.getSupportMods().worldmapSupport.getMapDimension();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getLastPlayerDimDiv();
        } else {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = class_310.method_1551().field_1687.method_27983();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = 1.0;
        }
        ((PlayerTrackerMinimapElementRenderContext)this.context).helper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, class_4597.class_4598 renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider) {
        rendererProvider.draw(((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.method_22993();
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(PlayerTrackerMinimapElement<?> e, boolean highlit, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, class_332 guiGraphics, class_4597.class_4598 renderTypeBuffers) {
        if (!outOfBounds && e.wasRenderedOnRadar()) {
            return false;
        }
        class_4587 matrixStack = guiGraphics.method_51448();
        class_310 mc = class_310.method_1551();
        class_640 info = mc.method_1562().method_2871(e.getPlayerId());
        if (info != null) {
            class_1657 clientPlayer = mc.field_1687.method_18470(e.getPlayerId());
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, optionalDepth);
            matrixStack.method_22905(optionalScale, optionalScale, 1.0f);
            ((PlayerTrackerMinimapElementRenderContext)this.context).helper.addColoredRectToExistingBuffer(matrixStack.method_23760().method_23761(), ((PlayerTrackerMinimapElementRenderContext)this.context).outlineConsumer, -5.0f, -5.0f, 10, 10, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.method_22904(0.0, 0.0, 0.01);
            this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).uniqueTextureUIObjectRenderer, ((PlayerTrackerMinimapElementRenderContext)this.context).helper, matrixStack, clientPlayer, this.getPlayerSkin(clientPlayer, info));
            matrixStack.method_22909();
        }
        return false;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        return this.modMain.getSettings().displayTrackedPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext>(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

