/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import net.minecraft.class_310;
import net.minecraft.class_746;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ActivationBehaviour;
import nl.enjarai.doabarrelroll.config.LimitedModConfigServer;
import nl.enjarai.doabarrelroll.config.MigrationValue;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.config.serialization.ExpressionParserTypeAdapter;
import nl.enjarai.doabarrelroll.math.ExpressionParser;
import nl.enjarai.doabarrelroll.util.ToastUtil;

public class ModConfig {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ExpressionParser.class, (Object)new ExpressionParserTypeAdapter()).addSerializationExclusionStrategy((ExclusionStrategy)new MigrationValue.SerializationStrategy()).setPrettyPrinting().create();
    public static final ModConfig DEFAULT = new ModConfig();
    public static final Path CONFIG_FILE = Path.of("config", new String[0]).resolve("do_a_barrel_roll-client.json");
    public static ModConfig INSTANCE = ModConfig.loadConfigFile(CONFIG_FILE.toFile());
    int format_version_do_not_edit = 2;
    General general = new General();
    SensitivityConfig sensitivity = new SensitivityConfig();
    AdvancedConfig advanced = new AdvancedConfig();

    public static void touch() {
    }

    private void performMigrations() {
        if (this.format_version_do_not_edit <= 1) {
            boolean enabled = this.sensitivity.smoothing.smoothing_enabled;
            this.sensitivity.camera_smoothing.pitch = enabled ? 1.0 / this.sensitivity.smoothing.smoothing_pitch : 0.0;
            this.sensitivity.camera_smoothing.yaw = enabled ? 1.0 / this.sensitivity.smoothing.smoothing_yaw : 0.0;
            this.sensitivity.camera_smoothing.roll = enabled ? 1.0 / this.sensitivity.smoothing.smoothing_roll : 0.0;
        }
        this.format_version_do_not_edit = 2;
    }

    public boolean getModEnabled() {
        return this.general.mod_enabled;
    }

    public boolean getSwitchRollAndYaw() {
        return this.general.controls.switch_roll_and_yaw;
    }

    public boolean getMomentumBasedMouse() {
        return this.general.controls.momentum_based_mouse;
    }

    public double getMomentumMouseDeadzone() {
        return this.general.controls.momentum_mouse_deadzone;
    }

    public boolean getShowMomentumWidget() {
        return this.general.controls.show_momentum_widget;
    }

    public boolean getInvertPitch() {
        return this.general.controls.invert_pitch;
    }

    public ActivationBehaviour getActivationBehaviour() {
        return this.general.controls.activation_behaviour;
    }

    public boolean getDisableWhenSubmerged() {
        return this.general.controls.disable_when_submerged;
    }

    public boolean getShowHorizon() {
        return this.general.hud.show_horizon;
    }

    public boolean getEnableBanking() {
        return this.general.banking.enable_banking;
    }

    public double getBankingStrength() {
        return this.general.banking.banking_strength;
    }

    public boolean getSimulateControlSurfaceEfficacy() {
        return this.general.banking.simulate_control_surface_efficacy;
    }

    public boolean getAutomaticRighting() {
        return this.general.banking.automatic_righting;
    }

    public double getRightingStrength() {
        return this.general.banking.righting_strength;
    }

    public boolean getEnableThrust() {
        if (this.general.thrust.enable_thrust) {
            class_746 player;
            if (DoABarrelRollClient.isConnectedToRealms() && (player = class_310.method_1551().field_1724) != null && player.method_5687(2)) {
                return true;
            }
            return DoABarrelRollClient.HANDSHAKE_CLIENT.getConfig().map(LimitedModConfigServer::allowThrusting).orElse(false);
        }
        return false;
    }

    public boolean getEnableThrustClient() {
        return this.general.thrust.enable_thrust;
    }

    public double getMaxThrust() {
        return this.general.thrust.max_thrust;
    }

    public double getThrustAcceleration() {
        return this.general.thrust.thrust_acceleration;
    }

    public boolean getThrustParticles() {
        return this.general.thrust.thrust_particles;
    }

    public boolean getEnableEasterEggs() {
        return this.general.misc.enable_easter_eggs;
    }

    public double getSmoothingPitch() {
        return this.sensitivity.camera_smoothing.pitch;
    }

    public double getSmoothingYaw() {
        return this.sensitivity.camera_smoothing.yaw;
    }

    public double getSmoothingRoll() {
        return this.sensitivity.camera_smoothing.roll;
    }

    public Sensitivity getSmoothing() {
        return this.sensitivity.camera_smoothing;
    }

    public Sensitivity getDesktopSensitivity() {
        return this.sensitivity.desktop;
    }

    public double getDesktopPitch() {
        return this.sensitivity.desktop.pitch;
    }

    public double getDesktopYaw() {
        return this.sensitivity.desktop.yaw;
    }

    public double getDesktopRoll() {
        return this.sensitivity.desktop.roll;
    }

    public Sensitivity getControllerSensitivity() {
        return this.sensitivity.controller;
    }

    public double getControllerPitch() {
        return this.sensitivity.controller.pitch;
    }

    public double getControllerYaw() {
        return this.sensitivity.controller.yaw;
    }

    public double getControllerRoll() {
        return this.sensitivity.controller.roll;
    }

    public ExpressionParser getBankingXFormula() {
        return this.advanced.banking_x_formula;
    }

    public ExpressionParser getBankingYFormula() {
        return this.advanced.banking_y_formula;
    }

    public ExpressionParser getElevatorEfficacyFormula() {
        return this.advanced.elevator_efficacy_formula;
    }

    public ExpressionParser getAileronEfficacyFormula() {
        return this.advanced.aileron_efficacy_formula;
    }

    public ExpressionParser getRudderEfficacyFormula() {
        return this.advanced.rudder_efficacy_formula;
    }

    public void setModEnabled(boolean enabled) {
        this.general.mod_enabled = enabled;
    }

    public void setSwitchRollAndYaw(boolean enabled) {
        this.general.controls.switch_roll_and_yaw = enabled;
    }

    public void setMomentumBasedMouse(boolean enabled) {
        this.general.controls.momentum_based_mouse = enabled;
    }

    public void setMomentumMouseDeadzone(double deadzone) {
        this.general.controls.momentum_mouse_deadzone = deadzone;
    }

    public void setShowMomentumWidget(boolean enabled) {
        this.general.controls.show_momentum_widget = enabled;
    }

    public void setInvertPitch(boolean enabled) {
        this.general.controls.invert_pitch = enabled;
    }

    public void setActivationBehaviour(ActivationBehaviour behaviour) {
        this.general.controls.activation_behaviour = behaviour;
    }

    public void setDisableWhenSubmerged(boolean enabled) {
        this.general.controls.disable_when_submerged = enabled;
    }

    public void setShowHorizon(boolean enabled) {
        this.general.hud.show_horizon = enabled;
    }

    public void setEnableBanking(boolean enabled) {
        this.general.banking.enable_banking = enabled;
    }

    public void setBankingStrength(double strength) {
        this.general.banking.banking_strength = strength;
    }

    public void setSimulateControlSurfaceEfficacy(boolean enabled) {
        this.general.banking.simulate_control_surface_efficacy = enabled;
    }

    public void setAutomaticRighting(boolean enabled) {
        this.general.banking.automatic_righting = enabled;
    }

    public void setRightingStrength(double strength) {
        this.general.banking.righting_strength = strength;
    }

    public void setEnableThrust(boolean enabled) {
        this.general.thrust.enable_thrust = enabled;
    }

    public void setMaxThrust(double thrust) {
        this.general.thrust.max_thrust = thrust;
    }

    public void setThrustAcceleration(double acceleration) {
        this.general.thrust.thrust_acceleration = acceleration;
    }

    public void setThrustParticles(boolean enabled) {
        this.general.thrust.thrust_particles = enabled;
    }

    public void setEnableEasterEggs(boolean enabled) {
        this.general.misc.enable_easter_eggs = enabled;
    }

    public void setSmoothingPitch(double pitch) {
        this.sensitivity.camera_smoothing.pitch = pitch;
    }

    public void setSmoothingYaw(double yaw) {
        this.sensitivity.camera_smoothing.yaw = yaw;
    }

    public void setSmoothingRoll(double roll) {
        this.sensitivity.camera_smoothing.roll = roll;
    }

    public void setDesktopSensitivity(Sensitivity sensitivity) {
        this.sensitivity.desktop = sensitivity;
    }

    public void setDesktopPitch(double pitch) {
        this.sensitivity.desktop.pitch = pitch;
    }

    public void setDesktopYaw(double yaw) {
        this.sensitivity.desktop.yaw = yaw;
    }

    public void setDesktopRoll(double roll) {
        this.sensitivity.desktop.roll = roll;
    }

    public void setControllerSensitivity(Sensitivity sensitivity) {
        this.sensitivity.controller = sensitivity;
    }

    public void setControllerPitch(double pitch) {
        this.sensitivity.controller.pitch = pitch;
    }

    public void setControllerYaw(double yaw) {
        this.sensitivity.controller.yaw = yaw;
    }

    public void setControllerRoll(double roll) {
        this.sensitivity.controller.roll = roll;
    }

    public void setBankingXFormula(ExpressionParser formula) {
        this.advanced.banking_x_formula = formula;
    }

    public void setBankingYFormula(ExpressionParser formula) {
        this.advanced.banking_y_formula = formula;
    }

    public void setElevatorEfficacyFormula(ExpressionParser formula) {
        this.advanced.elevator_efficacy_formula = formula;
    }

    public void setAileronEfficacyFormula(ExpressionParser formula) {
        this.advanced.aileron_efficacy_formula = formula;
    }

    public void setRudderEfficacyFormula(ExpressionParser formula) {
        this.advanced.rudder_efficacy_formula = formula;
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE.toFile());
    }

    public RotationInstant configureRotation(RotationInstant rotationInstant, RollContext context) {
        double pitch = rotationInstant.pitch();
        double yaw = rotationInstant.yaw();
        double roll = rotationInstant.roll();
        if (!this.getSwitchRollAndYaw()) {
            double temp = yaw;
            yaw = roll;
            roll = temp;
        }
        if (this.getInvertPitch()) {
            pitch = -pitch;
        }
        return RotationInstant.of(pitch, yaw, roll);
    }

    public void notifyPlayerOfServerConfig(LimitedModConfigServer serverConfig) {
        if (!serverConfig.allowThrusting() && this.general.thrust.enable_thrust) {
            ToastUtil.toasty("thrusting_disabled_by_server");
        }
        if (serverConfig.forceEnabled() && !this.general.mod_enabled) {
            ToastUtil.toasty("mod_forced_enabled_by_server");
        }
    }

    private static ModConfig loadConfigFile(File file) {
        ModConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (ModConfig)GSON.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ModConfig();
        }
        config.performMigrations();
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class General {
        boolean mod_enabled = true;
        Controls controls = new Controls();
        Hud hud = new Hud();
        Banking banking = new Banking();
        Thrust thrust = new Thrust();
        Misc misc = new Misc();

        General() {
        }

        static class Controls {
            boolean switch_roll_and_yaw = false;
            boolean invert_pitch = false;
            boolean momentum_based_mouse = false;
            double momentum_mouse_deadzone = 0.2;
            boolean show_momentum_widget = true;
            ActivationBehaviour activation_behaviour = ActivationBehaviour.VANILLA;
            boolean disable_when_submerged = true;

            Controls() {
            }
        }

        static class Hud {
            boolean show_horizon = false;

            Hud() {
            }
        }

        static class Banking {
            boolean enable_banking = true;
            double banking_strength = 20.0;
            boolean simulate_control_surface_efficacy = false;
            boolean automatic_righting = false;
            double righting_strength = 50.0;

            Banking() {
            }
        }

        static class Thrust {
            boolean enable_thrust = false;
            double max_thrust = 2.0;
            double thrust_acceleration = 0.1;
            boolean thrust_particles = true;

            Thrust() {
            }
        }

        static class Misc {
            boolean enable_easter_eggs = true;

            Misc() {
            }
        }
    }

    static class SensitivityConfig {
        @MigrationValue
        Smoothing smoothing = new Smoothing();
        Sensitivity camera_smoothing = new Sensitivity(1.0, 2.5, 1.0);
        Sensitivity desktop = new Sensitivity();
        Sensitivity controller = new Sensitivity();

        SensitivityConfig() {
        }

        static class Smoothing {
            boolean smoothing_enabled = true;
            double smoothing_pitch = 1.0;
            double smoothing_yaw = 0.4;
            double smoothing_roll = 1.0;

            Smoothing() {
            }
        }
    }

    static class AdvancedConfig {
        ExpressionParser banking_x_formula = new ExpressionParser("sin($roll * TO_RAD) * cos($pitch * TO_RAD) * 10 * $banking_strength");
        ExpressionParser banking_y_formula = new ExpressionParser("(-1 + cos($roll * TO_RAD)) * cos($pitch * TO_RAD) * 10 * $banking_strength");
        ExpressionParser elevator_efficacy_formula = new ExpressionParser("$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z");
        ExpressionParser aileron_efficacy_formula = new ExpressionParser("$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z");
        ExpressionParser rudder_efficacy_formula = new ExpressionParser("$velocity_x * $look_x + $velocity_y * $look_y + $velocity_z * $look_z");

        AdvancedConfig() {
        }
    }
}

