/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.IdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.StringSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagIdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.FontManagerFields;
import com.mt1006.nbt_ac.mixin.fields.KeyMappingFields;
import com.mt1006.nbt_ac.mixin.fields.MinecraftFields;
import com.mt1006.nbt_ac.mixin.fields.TextColorFields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_378;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public enum NbtSuggestionSubtype {
    NONE,
    ENUM,
    DESCRIBED_ENUM,
    BLOCK_STATE_ENUM,
    TAG,
    BLOCK_STATE_TAG,
    SPAWN_EGG,
    REGISTRY_ID,
    REGISTRY_KEY,
    RECIPE,
    FONT,
    RANDOM_UUID,
    INVENTORY_SLOT,
    KEYBIND,
    JSON_TEXT,
    JSON_TEXT_COMPOUND,
    JSON_TEXT_COLOR,
    ENTITY_SELECTOR,
    HOVER_EVENT_CONTENTS,
    ENCHANTMENTS;

    private static final List<String> JSON_TEXT_TYPE_SPECIFIC;
    private static final List<String> JSON_TEXT_TYPE_HAS_SEPARATOR;

    public String getName() {
        return this.name().toLowerCase();
    }

    public static NbtSuggestionSubtype fromName(String name) {
        try {
            return NbtSuggestionSubtype.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return NONE;
        }
    }

    public <T> boolean getSubtypeSuggestions(NbtSuggestion suggestion, SuggestionList suggestionList, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this) {
            case ENUM: {
                if (data == null) break;
                suggestionList.clear();
                for (String substring : data.split(";")) {
                    suggestionList.add(CustomSuggestion.fromType(substring, null, suggestion.type, parserType, 0));
                }
                return true;
            }
            case DESCRIBED_ENUM: {
                if (data == null) break;
                suggestionList.clear();
                String suggestionText = null;
                for (String substring : data.split(";")) {
                    if (suggestionText == null) {
                        suggestionText = substring;
                        continue;
                    }
                    suggestionList.add(CustomSuggestion.fromType(suggestionText, String.format("<%s>", substring), suggestion.type, parserType, 0));
                    suggestionText = null;
                }
                return true;
            }
            case REGISTRY_KEY: 
            case REGISTRY_ID: {
                if (data == null) break;
                try {
                    class_2960 registryLocation = new class_2960(data);
                    class_2378 registry = (class_2378)RegistryUtils.REGISTRY.method_10223(registryLocation);
                    if (registry == null) break;
                    suggestionList.clear();
                    if (this == REGISTRY_ID) {
                        for (Object object : registry) {
                            suggestionList.addRaw(Integer.toString(registry.method_10206(object)), "\"" + registry.method_10221(object) + "\" [#" + registryLocation.method_12832() + "]");
                        }
                    } else {
                        for (Object object : registry) {
                            suggestionList.add(new IdSuggestion(registry.method_10221(object), "[#" + registryLocation.method_12832() + "]", parserType));
                        }
                    }
                }
                catch (Exception registryLocation) {
                    // empty catch block
                }
                return true;
            }
            case RECIPE: {
                class_638 recipeLevel = class_310.method_1551().field_1687;
                if (recipeLevel == null) break;
                suggestionList.clear();
                for (class_2960 id : (class_2960[])recipeLevel.method_8433().method_8127().toArray(class_2960[]::new)) {
                    suggestionList.add(new IdSuggestion(id, null, parserType));
                }
                return true;
            }
            case FONT: {
                suggestionList.clear();
                class_378 fontManager = ((MinecraftFields)class_310.method_1551()).getFontManager();
                for (class_2960 id : ((FontManagerFields)fontManager).getFontSets().keySet()) {
                    suggestionList.add(new IdSuggestion(id, "[#font]", parserType));
                }
                return true;
            }
            case JSON_TEXT: {
                suggestionList.clear();
                NbtSuggestionSubtype.getJsonTextPrefixSuggestions(suggestionList, true);
                return true;
            }
            case JSON_TEXT_COLOR: {
                suggestionList.clear();
                suggestionList.addRaw("\"#", "[#json_color]", 1);
                Map<String, class_5251> colorMap = TextColorFields.getNAMED_COLORS();
                if (colorMap == null) {
                    return true;
                }
                for (Map.Entry<String, class_5251> entry : colorMap.entrySet()) {
                    String subtext = String.format("(#%06X) [#json_color]", entry.getValue().method_27716());
                    suggestionList.add(new StringSuggestion(entry.getKey(), subtext, parserType));
                }
                return true;
            }
            case RANDOM_UUID: {
                suggestionList.clear();
                UUID randomUUID = UUID.randomUUID();
                int uuidInt0 = (int)randomUUID.getLeastSignificantBits();
                int uuidInt1 = (int)(randomUUID.getLeastSignificantBits() >>> 32);
                int uuidInt2 = (int)randomUUID.getMostSignificantBits();
                int uuidInt3 = (int)(randomUUID.getMostSignificantBits() >>> 32);
                String uuidString = String.format("[I;%d, %d, %d, %d]", uuidInt3, uuidInt2, uuidInt1, uuidInt0);
                suggestionList.addRaw(uuidString, "[#random_uuid]");
                return true;
            }
            case INVENTORY_SLOT: {
                int i;
                suggestionList.clear();
                NbtSuggestion.Type type = suggestion.type;
                for (i = 0; i < 9; ++i) {
                    String subtext = String.format("(Hotbar %d) [#inventory_slot]", i + 1);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                for (i = 9; i < 35; ++i) {
                    int row = (i - 9) / 9 + 1;
                    int column = (i - 9) % 9 + 1;
                    String subtext = String.format("(Storage %d:%d) [#inventory_slot]", row, column);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                suggestionList.addRaw("100" + type.suffix, "(Feet) [#inventory_slot]");
                suggestionList.addRaw("101" + type.suffix, "(Legs) [#inventory_slot]");
                suggestionList.addRaw("102" + type.suffix, "(Chest) [#inventory_slot]");
                suggestionList.addRaw("103" + type.suffix, "(Head) [#inventory_slot]");
                suggestionList.addRaw("-106" + type.suffix, "(Off-hand) [#inventory_slot]");
                return true;
            }
            case KEYBIND: {
                suggestionList.clear();
                Map<String, class_304> keyMap = KeyMappingFields.getALL();
                if (keyMap == null) break;
                for (String str : keyMap.keySet()) {
                    String subtext = "\"" + class_2561.method_43471((String)str).getString() + "\" [#keybind]";
                    suggestionList.add(new StringSuggestion(str, subtext, parserType));
                }
                return true;
            }
            case ENTITY_SELECTOR: {
                suggestionList.clear();
                suggestionList.add(new StringSuggestion("@p", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@a", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@r", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@s", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@e", "[#entity_selector]", parserType));
                return true;
            }
        }
        return false;
    }

    public <T extends Comparable<T>> void getSubtypeTagSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this) {
            case TAG: {
                if (data == null) break;
                data = data.replace("block/item/", "block/");
                data = data.replace("entity/item/", "entity/");
                NbtSuggestions tagSuggestions = NbtSuggestionManager.get(data);
                suggestionList.addAll(tagSuggestions, data, parserType);
                break;
            }
            case BLOCK_STATE_TAG: {
                try {
                    if (data == null) break;
                    if (data.startsWith("block/")) {
                        data = data.substring(6);
                    } else if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    class_1792 blockItem = RegistryUtils.ITEM.get(new class_2960(data));
                    if (!(blockItem instanceof class_1747)) break;
                    for (class_2769 property : ((class_1747)blockItem).method_7711().method_9564().method_28501()) {
                        NbtSuggestion nbtSuggestion = new NbtSuggestion(property.method_11899(), NbtSuggestion.Type.STRING);
                        nbtSuggestion.subtype = BLOCK_STATE_ENUM;
                        StringBuilder enumStringBuilder = new StringBuilder();
                        for (Comparable possibleValue : property.method_11898()) {
                            enumStringBuilder.append(property.method_11901(possibleValue)).append(";");
                        }
                        nbtSuggestion.subtypeData = enumStringBuilder.toString();
                        suggestionList.add(new TagSuggestion(nbtSuggestion, parserType));
                    }
                    break;
                }
                catch (Exception blockItem) {
                    break;
                }
            }
            case SPAWN_EGG: {
                try {
                    class_1792 item;
                    if (data == null) break;
                    if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    if (!((item = RegistryUtils.ITEM.get(new class_2960(data))) instanceof class_1826)) break;
                    String key = RegistryUtils.ENTITY_TYPE.getKey(((class_1826)item).method_8015(null)).toString();
                    NbtSuggestions spawnEggSuggestions = NbtSuggestionManager.get("entity/" + key);
                    suggestionList.addAll(spawnEggSuggestions, data, parserType);
                }
                catch (Exception exception) {}
                break;
            }
            case JSON_TEXT_COMPOUND: {
                NbtSuggestionSubtype.getJsonCompoundSuggestions(suggestionList, parentInfo, parserType);
                break;
            }
            case HOVER_EVENT_CONTENTS: {
                NbtSuggestionSubtype.getHoverEventContentsSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case ENCHANTMENTS: {
                for (class_2960 id : RegistryUtils.ENCHANTMENT.keySet()) {
                    NbtSuggestion tempSuggestion = new NbtSuggestion(id.toString(), NbtSuggestion.Type.INT);
                    suggestionList.add(new TagIdSuggestion(tempSuggestion, id, parserType, true));
                }
                break;
            }
        }
    }

    public static void getJsonTextPrefixSuggestions(SuggestionList suggestionList, boolean inner) {
        String jsonSuggestion;
        String string = jsonSuggestion = inner ? ModConfig.getJsonStringSuggestion() : "\"";
        if (jsonSuggestion != null) {
            suggestionList.addRaw(jsonSuggestion, "(simple string) [#json_text]", 3);
        }
        suggestionList.addRaw(inner ? "'{" : "{", "(json structure) [#json_text]", 2);
        suggestionList.addRaw(inner ? "'[" : "[", "(json list) [#json_text]", 1);
    }

    private static void getJsonCompoundSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        suggestionList.addAll(NbtSuggestionManager.get("json_text/common"), parserType);
        String contentType = NbtSuggestionSubtype.jsonTextInit(suggestionList, parentInfo, parserType);
        for (String str : JSON_TEXT_TYPE_SPECIFIC) {
            int priority = contentType != null && !str.equals(contentType) ? -1 : 0;
            suggestionList.addAll(NbtSuggestionManager.get("json_text/type_specific/" + str), parserType, priority);
        }
        int priority = contentType != null && !JSON_TEXT_TYPE_HAS_SEPARATOR.contains(contentType) ? -1 : 0;
        suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/separator"), parserType, priority);
    }

    @Nullable
    private static String jsonTextInit(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        Map<Object, Object> tagMap;
        NbtSuggestions initialContent = NbtSuggestionManager.get("json_text/initial_content");
        if (initialContent == null) {
            return null;
        }
        Map<Object, Object> map = tagMap = parentInfo.tagMap != null ? parentInfo.tagMap : Map.of();
        if (tagMap.containsKey("type")) {
            String valueType = (String)tagMap.get("type");
            NbtSuggestion typeSuggestion = initialContent.get("type");
            NbtSuggestion valueSuggestion = initialContent.get(valueType);
            if (typeSuggestion != null) {
                suggestionList.add(new TagSuggestion(typeSuggestion, parserType, 100));
            }
            if (valueSuggestion != null) {
                suggestionList.add(new TagSuggestion(valueSuggestion, parserType, 100));
            }
            for (NbtSuggestion suggestion : initialContent.getAll()) {
                if (suggestion == typeSuggestion || suggestion == valueSuggestion) continue;
                suggestionList.add(new TagSuggestion(suggestion, parserType, -1));
            }
            return valueType;
        }
        for (NbtSuggestion suggestion : initialContent.getAll()) {
            if (!tagMap.containsKey(suggestion.tag)) continue;
            suggestionList.addAll(initialContent, parserType, -1);
            return NbtSuggestionSubtype.jsonTextTypeFromTag(suggestion.tag);
        }
        suggestionList.addAll(initialContent, parserType, 100);
        return null;
    }

    private static String jsonTextTypeFromTag(String tag) {
        return tag.equals("translate") ? "translatable" : tag;
    }

    private static void getHoverEventContentsSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        String hoverEvent;
        if (parentInfo.parentTagMap == null || !parentInfo.parentTagMap.containsKey("action")) {
            return;
        }
        switch (hoverEvent = parentInfo.parentTagMap.get("action")) {
            case "show_text": {
                JSON_TEXT_COMPOUND.getSubtypeTagSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case "show_item": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_item"), parserType);
                break;
            }
            case "show_entity": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_entity"), parserType);
            }
        }
    }

    static {
        JSON_TEXT_TYPE_SPECIFIC = List.of("nbt", "translatable");
        JSON_TEXT_TYPE_HAS_SEPARATOR = List.of("nbt", "selector");
    }
}

