/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.resourceloader.ParseJson;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestionSubtype;
import com.mt1006.nbt_ac.config.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Prediction {
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Operation> operations = new ArrayList<Operation>();

    public Prediction(Pair<JsonArray, JsonArray> prediction) {
        ((JsonArray)prediction.getLeft()).forEach(element -> this.conditions.add(new Condition(element.getAsJsonObject())));
        ((JsonArray)prediction.getRight()).forEach(element -> this.operations.add(new Operation(element.getAsJsonObject())));
    }

    public void execute() {
        for (Condition condition : this.conditions) {
            Collection<NbtSuggestion> matching = condition.matchingSuggestions();
            if (((Boolean)ModConfig.debugMode.val).booleanValue() && matching.isEmpty()) {
                NBTac.LOGGER.warn("No matching suggestions - {}", (Object)condition);
            }
            for (NbtSuggestion suggestion : matching) {
                this.operations.forEach(operation -> operation.execute(suggestion));
            }
        }
    }

    private static class Condition {
        @Nullable
        private final String root;
        @Nullable
        private final String path;

        public Condition(JsonObject object) {
            JsonElement rootElement = object.get("root");
            this.root = rootElement != null ? rootElement.getAsString() : null;
            JsonElement pathElement = object.get("path");
            this.path = pathElement != null ? pathElement.getAsString() : null;
        }

        public Collection<NbtSuggestion> matchingSuggestions() {
            if (this.path != null) {
                if (this.path.startsWith("*")) {
                    if (this.root != null) {
                        return List.of();
                    }
                    String key = this.path.substring(1);
                    return NbtSuggestions.suffixFullMap.get((Object)key);
                }
                if (this.path.endsWith("*")) {
                    if (this.root != null) {
                        return List.of();
                    }
                    String key = this.path.substring(0, this.path.length() - 1);
                    return NbtSuggestions.prefixFullMap.get((Object)key);
                }
                if (this.root == null) {
                    return NbtSuggestions.fullMap.get((Object)this.path);
                }
                NbtSuggestions suggestionsFromRoot = NbtSuggestionManager.get(this.root);
                NbtSuggestion suggestionFromRoot = suggestionsFromRoot != null ? suggestionsFromRoot.get(this.path) : null;
                return suggestionFromRoot != null ? List.of(suggestionFromRoot) : List.of();
            }
            if (this.root != null) {
                return List.of(NbtSuggestion.getDummyCompound(NbtSuggestionManager.get(this.root)));
            }
            return List.of();
        }

        public String toString() {
            return String.format("root:%s path:%s", this.root, this.path);
        }
    }

    private static class Operation {
        @Nullable
        public final String on;
        @Nullable
        public final String with;
        public final String type;
        public final String val;

        public Operation(JsonObject object) {
            JsonElement onElement = object.get("on");
            this.on = onElement != null ? onElement.getAsString() : null;
            JsonElement withElement = object.get("with");
            this.with = withElement != null ? withElement.getAsString() : null;
            JsonElement typeElement = object.get("type");
            this.type = typeElement != null ? typeElement.getAsString() : "";
            JsonElement valElement = object.get("val");
            this.val = valElement != null ? valElement.getAsString() : "";
        }

        public void execute(NbtSuggestion suggestion) {
            if (this.on == null) {
                this.executeOn(suggestion, null);
            } else if (suggestion.subcompound != null) {
                this.executeOn(suggestion.subcompound.get(this.on), suggestion.subcompound);
            }
        }

        private void executeOn(@Nullable NbtSuggestion suggestion, @Nullable NbtSuggestions root) {
            if (suggestion == null) {
                return;
            }
            switch (this.type) {
                case "override_unknown": {
                    if (suggestion.type != NbtSuggestion.Type.UNKNOWN) {
                        return;
                    }
                    suggestion.setType(ParseJson.parseType(this.val));
                    suggestion.changeSuggestionSource(NbtSuggestion.Source.TYPE_PREDICTION);
                    return;
                }
                case "set_type": {
                    int atPos = this.val.indexOf(64);
                    suggestion.setType(ParseJson.parseType(atPos != -1 ? this.val.substring(0, atPos) : this.val));
                    suggestion.changeSuggestionSource(NbtSuggestion.Source.TYPE_PREDICTION);
                    if (atPos == -1) {
                        return;
                    }
                }
                case "set_subtype": {
                    int slashPos = this.val.indexOf(47);
                    suggestion.subtype = NbtSuggestionSubtype.fromName(slashPos != -1 ? this.val.substring(0, slashPos) : this.val);
                    if (slashPos != -1) {
                        suggestion.subtypeData = this.val.substring(slashPos + 1);
                    }
                    suggestion.subtypeWith = this.with;
                    suggestion.changeSuggestionSource(NbtSuggestion.Source.SUBTYPE_PREDICTION);
                    return;
                }
                case "set_subcompound": {
                    if (suggestion.type == NbtSuggestion.Type.UNKNOWN) {
                        suggestion.type = NbtSuggestion.Type.COMPOUND;
                    } else if (suggestion.type == NbtSuggestion.Type.LIST && suggestion.listType == NbtSuggestion.Type.UNKNOWN) {
                        suggestion.listType = NbtSuggestion.Type.COMPOUND;
                    }
                    suggestion.subcompound = NbtSuggestionManager.get(this.val);
                    suggestion.changeSuggestionSource(NbtSuggestion.Source.COMPOUND_PREDICTION);
                    return;
                }
            }
            if (!suggestion.hasSubcompound()) {
                return;
            }
            switch (this.type) {
                case "recursion": {
                    if (root == null) {
                        return;
                    }
                    suggestion.subcompound = root;
                    suggestion.changeSuggestionSource(NbtSuggestion.Source.COMPOUND_PREDICTION);
                    return;
                }
                case "add_tag": {
                    int thirdSlash;
                    int firstSlash = this.val.indexOf(47);
                    int secondSlash = firstSlash != -1 ? this.val.indexOf(47, firstSlash + 1) : -1;
                    int n = thirdSlash = secondSlash != -1 ? this.val.indexOf(47, secondSlash + 1) : -1;
                    if (firstSlash == -1) {
                        return;
                    }
                    String tagStr = this.val.substring(0, firstSlash);
                    String typeStr = secondSlash != -1 ? this.val.substring(firstSlash + 1, secondSlash) : this.val.substring(firstSlash + 1);
                    NbtSuggestion.Type type = NbtSuggestion.Type.fromName(typeStr);
                    NbtSuggestion newSuggestion = new NbtSuggestion(tagStr, type, NbtSuggestion.Source.PREDICTION);
                    if (secondSlash != -1) {
                        String subtypeStr = thirdSlash != -1 ? this.val.substring(secondSlash + 1, thirdSlash) : this.val.substring(secondSlash + 1);
                        String subtypeDataStr = thirdSlash != -1 ? this.val.substring(thirdSlash + 1) : null;
                        newSuggestion.subtype = NbtSuggestionSubtype.fromName(subtypeStr);
                        newSuggestion.subtypeData = subtypeDataStr;
                    }
                    suggestion.getSubcompound().add(newSuggestion);
                    return;
                }
                case "add_compound": {
                    int slash = this.val.indexOf(47);
                    NbtSuggestion compoundSuggestion = new NbtSuggestion(this.val.substring(0, slash), NbtSuggestion.Type.COMPOUND, NbtSuggestion.Source.PREDICTION);
                    compoundSuggestion.subcompound = NbtSuggestionManager.get(this.val.substring(slash + 1));
                    suggestion.getSubcompound().add(compoundSuggestion);
                    return;
                }
                case "copy_tags": {
                    NbtSuggestions copyTagsFrom = NbtSuggestionManager.get(this.val);
                    if (copyTagsFrom != null) {
                        suggestion.getSubcompound().copyAll(copyTagsFrom, true);
                    }
                    return;
                }
            }
            NBTac.LOGGER.warn("Unknown prediction type: {}", (Object)this.type);
        }
    }
}

