/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.cache;

import com.mt1006.nbt_ac.autocomplete.loader.cache.CacheFile;
import com.mt1006.nbt_ac.autocomplete.loader.cache.CacheIndex;
import com.mt1006.nbt_ac.config.ModConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeSet;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class TypeCache {
    private static final String DIRECTORY_NAME = "cache/nbt_ac";
    private static final String INDEX_FILENAME = "_index.txt";
    private static File directory = null;
    private static String id;
    private static String idHash;
    private static CacheIndex index;

    public static boolean isEnabled() {
        return (Boolean)ModConfig.useCache.val;
    }

    public static boolean load() {
        directory = new File(class_310.method_1551().field_1697, DIRECTORY_NAME);
        directory.mkdirs();
        id = TypeCache.genInstanceId();
        idHash = TypeCache.getMD5(id);
        index = new CacheIndex(new File(directory, INDEX_FILENAME));
        return index.findAndLoad(directory, id, idHash);
    }

    public static void add() {
        int elementPos = index.getNextFilePos();
        CacheFile.save(CacheIndex.getFile(directory, elementPos), id);
        index.add(idHash, elementPos);
    }

    public static void updateIndex() {
        index.save();
    }

    private static String genInstanceId() {
        String modVersionTag = String.format("%s/%s/%s/%s;", "Fabric", "1.20.4", "1.3.4", CacheFile.MAX_RADIX);
        StringBuilder builder = new StringBuilder(modVersionTag);
        TreeSet<String> mods = new TreeSet<String>();
        for (ModContainer modInfo : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = modInfo.getMetadata();
            mods.add(String.format("%s@%s;", metadata.getId(), metadata.getVersion().getFriendlyString()));
        }
        mods.forEach(builder::append);
        return builder.toString();
    }

    @Nullable
    private static String getMD5(String str) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = md5.digest();
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException exception) {
            return null;
        }
    }

    static {
        index = null;
    }
}

