/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITickableElement;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.style.IStyled;
import com.minelittlepony.common.client.gui.style.Style;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Button
extends class_4264
implements IBounded,
ITextContext,
IStyled<Button>,
ITickableElement {
    protected static final class_8666 TEXTURES = new class_8666(new class_2960("widget/button"), new class_2960("widget/button_disabled"), new class_2960("widget/button_highlighted"));
    private Style style = new Style();
    private final Bounds bounds;
    private static final Consumer<Button> NONE = v -> {};
    @NotNull
    private Consumer<Button> action = NONE;
    @NotNull
    private Consumer<Button> update = NONE;
    @Nullable
    private Tooltip prevTooltip;

    public Button(int x, int y) {
        this(x, y, 200, 20);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height, class_5244.field_39003);
        this.bounds = new Bounds(y, x, width, height);
    }

    public Button onClick(@NotNull Consumer<? extends Button> callback) {
        this.action = Objects.requireNonNull(callback);
        return this;
    }

    public Button onUpdate(@NotNull Consumer<? extends Button> callback) {
        this.update = Objects.requireNonNull(callback);
        return this;
    }

    public Button setEnabled(boolean enable) {
        this.field_22763 = enable;
        return this;
    }

    public Button setVisible(boolean visible) {
        this.field_22764 = visible;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Button setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds.copy(bounds);
        this.method_46421(bounds.left);
        this.method_46419(bounds.top);
        this.method_25358(bounds.width);
        this.method_53533(bounds.height);
    }

    public void method_46421(int x) {
        this.bounds.left = x;
        super.method_46421(x);
    }

    public void method_46419(int y) {
        this.bounds.top = y;
        super.method_46419(y);
    }

    public void method_25358(int width) {
        this.bounds.width = width;
        super.method_25358(width);
    }

    public void method_53533(int height) {
        this.bounds.height = height;
        this.field_22759 = height;
    }

    public void method_47399(class_6382 narrationMsg) {
        this.getStyle().getTooltip().ifPresent(tooltip -> tooltip.method_37020(narrationMsg));
    }

    public void method_25306() {
        this.action.accept(this);
    }

    @Override
    public void tick() {
        this.update.accept(this);
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.getBounds().contains(mouseX, mouseY);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
        this.getStyle().getTooltip().ifPresentOrElse(tooltip -> {
            if (tooltip != this.prevTooltip) {
                this.prevTooltip = tooltip;
                this.method_47400(tooltip.toTooltip(this));
            }
        }, () -> this.method_47400(null));
        class_310 mc = class_310.method_1551();
        context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.renderBackground(context, mc, mouseX, mouseY);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        this.method_25355(this.getStyle().getText());
        this.drawIcon(context, mouseX, mouseY, tickDelta);
        int foreColor = this.getStyle().getColor();
        if (!this.field_22763) {
            foreColor = 0xA0A0A0;
        } else if (this.method_49606()) {
            foreColor = 0xFFFFA0;
        }
        this.renderForeground(context, mc, mouseX, mouseY, foreColor | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    protected void renderBackground(class_332 context, class_310 mc, int mouseX, int mouseY) {
        context.method_52706(TEXTURES.method_52729(this.field_22763, this.method_25367()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    protected void drawIcon(class_332 context, int mouseX, int mouseY, float partialTicks) {
        if (this.getStyle().hasIcon()) {
            this.getStyle().getIcon().render(context, this.method_46426(), this.method_46427(), mouseX, mouseY, partialTicks);
        }
    }

    protected void renderForeground(class_332 context, class_310 mc, int mouseX, int mouseY, int foreColor) {
        this.method_48589(context, mc.field_1772, foreColor);
    }

    public void method_48589(class_332 context, class_327 textRenderer, int color) {
        Bounds bounds = this.getBounds();
        int left = this.getStyle().getIcon().getBounds().right();
        Button.method_52718((class_332)context, (class_327)textRenderer, (class_2561)this.method_25369(), (int)(bounds.left + left), (int)bounds.top, (int)(bounds.right() - 2), (int)bounds.bottom(), (int)color);
    }
}

