/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.dimension;

import com.minelittlepony.common.client.gui.dimension.Padding;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class Bounds {
    public int top;
    public int left;
    public int width;
    public int height;

    public static Bounds empty() {
        return new Bounds(0, 0, 0, 0);
    }

    public Bounds(int top, int left, int width, int height) {
        this.top = top;
        this.left = left;
        this.width = width;
        this.height = height;
    }

    public int right() {
        return this.left + this.width;
    }

    public int bottom() {
        return this.top + this.height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean contains(double x, double y) {
        return !this.isEmpty() && this.containsX(x) && this.containsY(y);
    }

    public boolean containsX(double x) {
        return !this.isEmpty() && x >= (double)this.left && x <= (double)(this.left + this.width);
    }

    public boolean containsY(double y) {
        return !this.isEmpty() && y >= (double)this.top && y <= (double)(this.top + this.height);
    }

    public Bounds add(Padding other) {
        return new Bounds(this.top - other.top, this.left - other.left, this.width + other.left + other.right, this.height + other.top + other.bottom);
    }

    public Bounds offset(Padding other) {
        return new Bounds(this.top + other.top, this.left + other.left, this.width, this.height);
    }

    public Bounds add(Bounds other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        int t = Math.min(this.top, other.top);
        int l = Math.min(this.left, other.left);
        int b = Math.max(this.top + this.height, other.top + other.height);
        int r = Math.max(this.left + this.width, other.left + other.width);
        int h = b - t;
        int w = r - l;
        return new Bounds(t, l, w, h);
    }

    public void copy(Bounds other) {
        this.top = other.top;
        this.left = other.left;
        this.width = other.width;
        this.height = other.height;
    }

    public void draw(class_332 context, int tint) {
        context.method_25294(this.left, this.top, this.left + this.width, this.top + this.height, tint);
    }

    public void translate(class_4587 matrices) {
        matrices.method_46416((float)this.left, (float)this.top, 0.0f);
    }

    public void debugMeasure(class_332 context) {
        class_1041 window = class_310.method_1551().method_22683();
        context.method_25294(this.left, -1000, this.left + 1, window.method_4502() * 9, -1);
        context.method_25294(this.left + this.width, -1000, this.left + this.width + 1, window.method_4502() * 9, -1);
        context.method_25294(-1000, this.top, window.method_4486(), this.top + 1, -1);
        context.method_25294(-1000, this.top + this.height, window.method_4486(), this.top + this.height + 1, -1);
    }

    protected boolean equals(Bounds o) {
        return this == o || o.top == this.top && o.left == this.left && o.width == this.width && o.height == this.height;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Bounds && this.equals((Bounds)o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.left;
        result = 31 * result + this.top;
        result = 31 * result + this.width;
        return result;
    }
}

