#ifdef SKY_VANILLA
uniform vec3 skyColor;
uniform vec3 fogColor;

vec3 skyCol = pow(skyColor, vec3(2.2)) * SKY_I * SKY_I;
vec3 fogCol = pow(fogColor, vec3(2.2)) * SKY_I * SKY_I;



#else
vec3 skyColSqrt = vec3(SKY_R * (1.0 + 0.2 * clamp((dot(-sunVec, upVec) + 0.4) * 8.8, 0.0, 1.0)), SKY_G * (1.0 + 0.22 * clamp((dot(-sunVec, upVec) + 0.4) * 8.8, 0.0, 1.0)), SKY_B) * (SKY_I * (1.0 - 0.2 * clamp((dot(-sunVec, upVec) + 0.4) * 8.8, 0.0, 1.0))) / 255.0;
vec3 fogColSqrt = vec3(FOG_R, FOG_G, FOG_B) * FOG_I / 255.0;
vec3 skyCol = skyColSqrt * skyColSqrt;
vec3 fogCol = fogColSqrt * fogColSqrt;

vec3 fogCavesColSqrt = vec3(CAVES_FOG_R, CAVES_FOG_G, CAVES_FOG_B) * (0.7 * CAVES_FOG_I + 0.3) / 255.0;
vec3 fogCavesCol = fogCavesColSqrt * fogCavesColSqrt * 0.04;

vec3 fogLushCavesColSqrt = vec3(LUSH_CAVES_FOG_R, LUSH_CAVES_FOG_G, LUSH_CAVES_FOG_B) * (0.7 * LUSH_CAVES_FOG_I + 0.3) / 255.0;
vec3 fogLushCavesCol = fogLushCavesColSqrt * fogLushCavesColSqrt * 0.04;

vec3 fogDripstoneCavesColSqrt = vec3(DRIPSTONE_CAVES_FOG_R, DRIPSTONE_CAVES_FOG_G, DRIPSTONE_CAVES_FOG_B) * (0.7 * DRIPSTONE_CAVES_FOG_I + 0.3) / 255.0;
vec3 fogDripstoneCavesCol = fogDripstoneCavesColSqrt * fogDripstoneCavesColSqrt * 0.04;

vec3 fogDeepDarkColSqrt = vec3(DEEP_DARK_FOG_R, DEEP_DARK_FOG_G, DEEP_DARK_FOG_B) * (0.7 * DEEP_DARK_FOG_I + 0.3) / 255.0;
vec3 fogDeepDarkCol = fogDeepDarkColSqrt * fogDeepDarkColSqrt * 0.04;
#endif