#if (WATER_MODE == 1 || WATER_MODE == 3) && !defined SKY_VANILLA && (!defined NETHER || !defined NETHER_VANILLA)
uniform vec3 fogColor;
#endif

void WaterFog(inout vec3 color, vec3 viewPos) {
    float fog = length(viewPos) / waterFogRange;
    fog = 1.0 - exp(-3.0 * fog);
    
    #if WATER_MODE == 0 || WATER_MODE == 2
    vec3 waterFogColor = waterColor.rgb * waterAlpha;
    #elif  WATER_MODE == 1 || WATER_MODE == 3
    #ifdef OVERWORLD
    vec3 waterFogColor = fogColor * fogColor * 0.5 * ((eyeBrightnessSmooth.y / 240.0) * 0.8 + 0.2) * (1.0 - rainStrength)
	 + rainStrength * vec3(weatherCol) * vec3(weatherCol) * 0.03 * ((eyeBrightnessSmooth.y / 240.0) * 0.8 + 0.2);
    #else
    vec3 waterFogColor = fogColor * fogColor * 0.5 * ((eyeBrightnessSmooth.y / 240.0) * 0.8 + 0.2);
    #endif
    #endif

    waterFogColor *= 0.125 * (1.0 - max(blindFactor, darknessFactor));

    #ifdef OVERWORLD
    vec3 waterFogTint = lightCol * (eyeBrightnessSmooth.y / 240.0) * shadowFade + 0.05;
    #endif
    #ifdef NETHER
    vec3 waterFogTint = netherCol.rgb;
    #endif
    #ifdef END
    vec3 waterFogTint = endCol.rgb;
    #endif
    waterFogTint = sqrt(waterFogTint * length(waterFogTint));

    color = mix(color, waterFogColor * waterFogTint, fog);
}