// UNUSED FOR NOW

#include "/lib/core.glsl"
#include "/lib/config.glsl"

layout(local_size_x = 16, local_size_y = 16, local_size_z = 1) in;
const vec2 workGroupsRender = vec2(1.0, 1.0);

uniform float frameTimeCounter;
uniform vec3 shadowLightDirection, sunDirectionPlr;
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse, shadowModelView, shadowProjection;
uniform sampler2D depthtex0, shadowcolor0;
uniform sampler2DShadow shadowtex1HW;

#include "/lib/view.glsl"
#include "/lib/fast_math.glsl"
#include "/lib/distort.glsl"
#include "/lib/rand.glsl"
#include "/lib/skylight.glsl"
#include "/lib/fog.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);
	immut float depth = texelFetch(depthtex0, texel, 0).r;
	immut vec2 texel_size = 1.0 / view();
	immut vec2 coord = fma(gl_GlobalInvocationID.xy, texel_size, 0.5 * texel_size);
	immut vec3 ndc = fma(vec3(coord, depth), vec3(2.0), vec3(-1.0));
	immut vec4 view_undiv = gbufferProjectionInverse * vec4(ndc, 1.0);
	vec3 view = view_undiv.xyz / view_undiv.w;

	immut float dist = length(view);

	vec3 ray = vec3(0.0);

	immut mat4 g_mv_inv_s_mv_proj = shadowProjection * shadowModelView * gbufferModelViewInverse;

	immut vec4 c_zero = gbufferProjectionInverse * vec4(ndc.xy, 0.0, 1.0);
	immut vec3 v_zero = c_zero.xyz / c_zero.w;

	immut vec2 seed = frameTimeCounter + coord * 1024.0;

	// todo!() don't sample outside of shadow distance
	// maybe also sample less frequently further away
	// look into an andragradsekvation for it :)
	for (uint i = 0u; i < 8u; ++i) {
		immut float dist = rand(i + seed) * 0.9;

		immut vec3 s_ndc = fma(distort((
			g_mv_inv_s_mv_proj * vec4(mix(v_zero, view, dist), 1.0)).xyz
		), vec3(0.5), vec3(0.5));

		ray += textureLod(shadowtex1HW, s_ndc, 0.0).rrr * textureLod(shadowcolor0, s_ndc.xy, 0.0).rgb * exp(lowp_rcp(fogState.y) * -5 * dist);
	}

	ray *= length(v_zero - view);

	float brightness = float(VL_BASE) * 0.000015 + float(isEyeInWater) * 0.005;

	#if VL_SUN || VL_SKY
		immut float proximity = max(0.0, dot(view / dist, shadowLightDirection));

		brightness += 0.0000125 * VL_SUN * pow(proximity, 64u) + 0.00001 * VL_SKY * pow(proximity, 2u);
	#endif

	fog_col = min(fog_col * (0.75 + brightness * ray * skylight()), 1.0);
}