#include "/lib/core.glsl"
#include "/lib/config.glsl"

out gl_PerVertex {
	vec4 gl_Position;
};

#ifdef ENTITY_SHADOWS
#endif
#ifdef PLAYER_SHADOWS
#endif
#ifdef BLOCK_ENTITY_SHADOWS
#endif

uniform vec3 shadowProjScale;
uniform mat4 modelViewMatrix;

#ifdef TERRAIN
	uniform vec3 chunkOffset;

	#if WAVES && defined MAYBE_FLUID
		in vec2 mc_Entity;

		#include "/lib/waves/offset.glsl"
	#endif
#endif

in vec3 vaPosition;

#ifdef TEXTURED
	uniform mat4 textureMatrix;

	in vec2 vaUV0;

	out VertexData { layout(location = 0) noperspective vec2 coord; } v;
#endif

#include "/lib/distort.glsl"

void main() {
	vec3 model = vaPosition;

	#ifdef TERRAIN
		model += chunkOffset;

		#if WAVES && defined MAYBE_FLUID
			if (mc_Entity.y > 0.5) model.y += wave(f16vec2(model.xz));
		#endif
	#endif

	// modelViewMatrix can be cut to a mat3 since shadowIntervalSize == 0.0
	// see custom uniform definition for `shadowProjScale`
	immut vec3 clip = shadowProjScale * (mat3(modelViewMatrix) * model);
	gl_Position = vec4(distort(clip.xy), clip.z, 1.0);

	#ifdef TEXTURED
		v.coord = mat4x2(textureMatrix) * vec4(vaUV0, 0.0, 1.0);
	#endif
}