#include "/lib/core.glsl"
#include "/lib/config.glsl"

const ivec3 workGroups = ivec3(1, 1, 1);
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

writeonly
#include "/buf/indirect.glsl"

writeonly
#include "/buf/indirect_sm_lit.glsl"

#if DCG_EXP || DCG_COLOR || DCG_BP
	writeonly
	#include "/buf/dcg.glsl"
#endif

#if INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS
	writeonly
	#include "/buf/index.glsl"
#endif

void main() {
	indirect.work_groups = uvec3(0u, 1u, 1u);
	indirect_sm_lit.work_groups = uvec3(0u, 1u, 1u);

	#if DCG_EXP || DCG_COLOR || DCG_BP
		dcg.max_color = vec3(1.0);
		dcg.min_val = 0.0;
		dcg.max_luma = 1.0;
	#endif

	#if INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS
		index.queue = 0u;
		index.len = uint16_t(0u);
	#endif
}