#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1,2,3 */
layout(location = 0) out vec4 colortex1;
layout(location = 1) out vec4 colortex2;
layout(location = 2) out uint colortex3;

#ifdef ALPHA_CHECK
	layout(depth_greater) out float gl_FragDepth;

	uniform float alphaTestRef;
#else
	layout(depth_unchanged) out float gl_FragDepth;
#endif

uniform sampler2D gtexture;

#ifdef NO_NORMAL
	uniform mat4 gbufferModelViewInverse;
#else
	#include "/lib/tbn/fsh.glsl"
#endif

#ifdef TERRAIN
	uniform ivec2 atlasSize;
#endif

#include "/lib/octa_normal.glsl"
#include "/lib/luminance.glsl"
#include "/lib/material/specular.glsl"
#include "/lib/material/normal.glsl"
#include "/lib/int_scale.glsl"

in VertexData {
	layout(location = 2) vec2 coord;
	layout(location = 2, component = 2) vec2 light;
	layout(location = 3) vec3 tint;
	layout(location = 3, component = 3) float ao;

	#if !(defined NM && defined MC_NORMAL_MAP)
		layout(location = 4) flat uvec2 uv_data;
	#endif

	#ifdef TERRAIN
		layout(location = 4, component = 2) flat uint emission;

		#if !(SM && defined MC_SPECULAR_MAP)
			layout(location = 1, component = 3) flat float avg_luma;
		#endif
	#endif
} v;

void main() {
	#ifdef TEX_ALPHA
		f16vec4 color = f16vec4(texture(gtexture, v.coord));
	#else
		f16vec3 color = f16vec3(texture(gtexture, v.coord).rgb);
	#endif

	#ifdef ALPHA_CHECK
		if (color.a < float16_t(alphaTestRef)) discard;
	#endif

	immut f16vec3 tint = f16vec3(v.tint);
	color.rgb *= tint;

	#ifdef NO_NORMAL
		immut vec3 normal = normalize(mat3(gbufferModelViewInverse) * vec3(0.0, 0.0, 1.0));
		immut vec3 tangent = normalize(mat3(gbufferModelViewInverse) * vec3(0.0, 1.0, 0.0));
		immut mat3 tbn = mat3(tangent, normalize(cross(tangent, normal)), normal);
	#else
		immut mat3 tbn = get_tbn();
	#endif

	#if !(defined NM && defined MC_NORMAL_MAP) || !(SM && defined MC_SPECULAR_MAP)
		immut float16_t luma = luminance(color.rgb);
	#endif

	#if defined NM && defined MC_NORMAL_MAP
		immut f16vec3 w_tex_normal = normalize(f16vec3(tbn * fma(texture(normals, v.coord).rgb, vec3(2.0), vec3(-1.0))));
	#else
		#ifdef TERRAIN
			immut vec2 atlas = vec2(atlasSize);
		#else
			immut vec2 atlas = vec2(textureSize(gtexture, 0));
		#endif

		immut f16vec3 w_tex_normal = normalize(f16vec3(tbn * gen_normal(gtexture, tint, v.coord, v.uv_data, atlas, luma)));

		/*
		immut ivec2 half_texels = ivec2(
			bitfieldExtract(v.uv_data.y, 0, 16),
			bitfieldExtract(v.uv_data.y, 16, 16)
		) / 2 - 1;
		immut vec2 atlas_texel = 1.0 / atlas;
		immut vec2 half_size = vec2(half_texels) * atlas_texel;

		immut vec2 local_coord = v.coord - unpackUnorm2x16(v.uv_data.x);
		color.rgb += vec4(
			local_coord.x > -half_size.x,
			local_coord.x < half_size.x,
			local_coord.y > -half_size.y,
			local_coord.y < half_size.y
		).rgb;
		*/
	#endif

	colortex2 = vec4(
		octa_encode(w_tex_normal),
		octa_encode(f16vec3(tbn[2]))
	);

	#if SM && defined MC_SPECULAR_MAP
		immut float16_t smoothness = map_smoothness(float16_t(texture(specular, v.coord).SM_CH));
	#else
		immut float16_t avg_luma =
			#ifdef TERRAIN
				float16_t(v.avg_luma);
			#else
				float16_t(0.8);
			#endif

		immut float16_t smoothness = gen_smoothness(luma, avg_luma);
	#endif

	colortex1 = vec4(color.rgb, smoothness);

	immut float16_t in_ao = float16_t(v.ao);
	immut float16_t ao = mix(
		smoothstep(float16_t(0.05), float16_t(0.8), in_ao),
		float16_t(1.0),
		float16_t(0.25)
	) * mix(in_ao, float16_t(1.0), float16_t(0.75));

	immut uvec2 light = int_scale(ao * f16vec2(
		float16_t(v.light.x),
		min(float16_t(1.0), float16_t(v.light.y) + float16_t(AMBIENT * 0.25) * in_ao)
	), 13u);
	uint packed_data = bitfieldInsert(light.x, light.y, 13, 13);

	// todo!() emissive map here
	#ifdef TERRAIN
		packed_data = bitfieldInsert(packed_data, v.emission, 26, 4);
	#endif

	colortex3 = packed_data;
	//const uint sss = 0u;
	//colortex3 = bitfieldInsert(packed_data, sss, 30, 1);
}