uniform float day;
uniform vec3 cameraPositionFract;

#ifdef HAND_LIGHT
	const float handLight = 0.0;
#endif

#ifdef LIGHT_LEVELS
	#include "/lib/llv.glsl"
#elif INDEXED_BLOCK_LIGHT
	readonly
	#include "/buf/index.glsl"

	#include "/lib/mhtn_dist.glsl"
#endif

#include "/lib/fast_math.glsl"
#include "/lib/luminance.glsl"
#include "/lib/brdf.glsl"
#include "/lib/norm_uv2.glsl"

// slightly less cool version of the lighting done in deferred1_a.csh, adapted to work in vertex shaders
f16vec3 indexed_block_light(vec3 pe, f16vec3 w_face_normal) {
	f16vec2 light = norm_uv2();
	light.y = min(float16_t(1.0), light.y + float16_t(AMBIENT * 0.25) * float16_t(vaColor.a));

	#ifdef LIGHT_LEVELS
		f16vec3 block_light = visualize_ll(light.x);
	#else
		f16vec3 block_light = light.x*light.x * f16vec3(1.2, 1.2, 1.0);
	#endif

	immut f16vec3 abs_pe = abs(f16vec3(pe));
	immut float16_t chebyshev_dist = max3(abs_pe.x, abs_pe.y, abs_pe.z);

	#if INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS
		if (light.x >= float16_t(1.0/15.0) && chebyshev_dist < float16_t(INDEX_DIST)) {
			immut vec3 offset = -255.5 - cameraPositionFract - gbufferModelViewInverse[3].xyz + index.offset - pe;

			f16vec3 diffuse = f16vec3(0.0);

			immut uint16_t index_len = index.len;
			for (uint16_t i = uint16_t(0u); i < index_len; ++i) {
				immut uint light_data = index.data[i];

				immut vec3 w_rel_light = vec3(
					bitfieldExtract(light_data, 0, 9),
					bitfieldExtract(light_data, 9, 9),
					bitfieldExtract(light_data, 18, 9)
				) + offset;

				immut f16vec3 f16_w_rel_light = f16vec3(w_rel_light);
				immut float16_t intensity = float16_t(bitfieldExtract(light_data, 27, 4));
				immut float16_t mhtn_dist = mhtn_length(f16_w_rel_light);

				if (mhtn_dist <= intensity) {
					immut uint16_t light_color = index.color[i];
					immut f16vec3 n_w_rel_light = f16vec3(normalize(w_rel_light));
					immut float16_t face_lambertian = dot(w_face_normal, n_w_rel_light);

					float16_t dist_light = length(f16_w_rel_light);
					if (bitfieldExtract(light_data.x, 31, 1) == 0u) dist_light *= dist_light;

					immut float16_t brightness = min(intensity - mhtn_dist, float16_t(1.0)) * intensity / dist_light;

					immut uint light_color_32 = uint(light_color);
					immut f16vec3 illum = min(brightness, float16_t(48.0)) * f16vec3(
						bitfieldExtract(light_color_32, 6, 5),
						bitfieldExtract(light_color_32, 0, 6),
						bitfieldExtract(light_color_32, 11, 5)
					);

					if (face_lambertian > float16_t(0.0)) {
						diffuse += face_lambertian * face_lambertian / PI_16 * illum;
					}

					diffuse = fma(f16vec3(IND_ILLUM + 0.05), illum, diffuse); // fake GI, with additional (+0.05, just picked at random) term not found in the solid version, to also fake light spreading through the material // it looks good idk
				}
			}

			if (dot(diffuse, f16vec3(1.0)) > float16_t(0.0)) {
				diffuse *= f16vec3(1.0 / (15.0 * vec3(31.0, 63.0, 31.0))); // Undo the multiplication from packing light color and brightness

				immut f16vec3 new_light = float16_t(INDEXED_BLOCK_LIGHT * 2) * light.x * diffuse;

				block_light = mix(new_light, block_light, smoothstep(float16_t(INDEX_DIST - 15), float16_t(INDEX_DIST), chebyshev_dist));
			}
		}
	#endif

	#ifdef NETHER
		const f16vec3 sky_light = f16vec3(0.3, 0.15, 0.2);
	#elif defined END
		const f16vec3 sky_light = f16vec3(0.15, 0.075, 0.2);
	#else
		immut float16_t sky_light = float16_t(1.0) - sqrt(float16_t(1.0) - light.y * clamp(float16_t(day) * float16_t(10.0), float16_t(0.25), float16_t(1.0)));
	#endif

	return sky_light * float16_t(0.4) + block_light;
}