// unpacks a unorm vec3 (11/11/10) from a uint
f16vec3 unpack_un11_11_10(uint data) {
	return f16vec3(
		bitfieldExtract(data, 0, 11),
		bitfieldExtract(data, 11, 11),
		bitfieldExtract(data, 22, 10)
	) / f16vec3(2047.0, 2047.0, 1023.0);
}

#include "/lib/int_scale.glsl"

uint pack_un11_11_10(vec3 color) {
	uvec3 scaled_color = int_scale(color, uvec3(11u, 11u, 10u));
	return bitfieldInsert(bitfieldInsert(scaled_color.r, scaled_color.g, 11, 11), scaled_color.b, 22, 10);
}