#if TONEMAP == 9 // SBDT
	/*
		https://github.com/bevyengine/bevy/blob/main/crates/bevy_core_pipeline/src/tonemapping/tonemapping_shared.wgsl

		MIT License

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in all
		copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.
	*/

	float sbdt_curve(float v) {
		immut float c = v + v*v + 0.5 * v*v*v;
		return c / (1.0 + c);
	}

	vec3 sbdt_curve(vec3 color) {
		immut vec3 c = color + color*color + 0.5 * color*color*color;
		return c / (1.0 + c);
	}
#endif

#include "/lib/luminance.glsl"

vec3 tonemap(vec3 color) {
	#if TONEMAP == 0 // Clamp
		//color = color / luminance(color) * min(luminance(color), 1.0); // kinda works
		//color = color / max3(color.r, color.g, color.b) * min(max3(color.r, color.g, color.b), 1.0); // cursed
		return clamp(color, 0.0, 1.0);
	#elif TONEMAP == 1 // Uchimura
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/uchimura.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		immut vec3 w0 = 1.0 - smoothstep(0.0, 0.22, color);
		immut vec3 w2 = step(0.532, color);
		const float a = pow(0.22, -0.33);

		return a * pow(color, vec3(1.33)) * w0 + color * (1.0 - w0 - w2) + fma(exp(0.532/0.468 - color / 0.468), vec3(-0.468), vec3(1.0)) * w2;
	#elif TONEMAP == 2 // Reinhard-Jodie
		color = pow(color, uvec3(5u));

		immut vec3 tv = color / (1.0 + color);

		return pow(mix(color / (dot(color, vec3(0.2125, 0.7154, 0.0721)) + 1.0), tv, tv), vec3(0.2));
	#elif TONEMAP == 3 // ACES
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/aces.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		return color * fma(color, vec3(2.51), vec3(0.03)) / fma(fma(color, vec3(2.43), vec3(0.59)), color, vec3(0.14));
	#elif TONEMAP == 4 // Lottes
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/lottes.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		const float a = (pow(8.0, 1.5632) - pow(0.18, 1.5632)) * 0.267;
		const float b = fma(pow(8.0, 1.6), 0.267, -pow(0.18, 1.6)) / a;
		const float c = (pow(8.0, 1.5632) * pow(0.18, 1.6) - pow(8.0, 1.6) * pow(0.18, 1.5632) * 0.267) / a;

		return pow(color, vec3(1.6)) / fma(pow(color, vec3(1.5632)), b.xxx, c.xxx);
	#elif TONEMAP == 5 // Unreal
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/unreal.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		return pow(color / (color + 0.155) * 1.019, vec3(2.2));
	#elif TONEMAP == 6 // Filmic
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/filmic.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		color = max(color - 0.004, 0.0);

		return pow(color * fma(color, vec3(6.2), vec3(0.5)) / fma(fma(color, vec3(6.2), vec3(1.7)), color, vec3(0.06)), vec3(2.2));
	#elif TONEMAP == 7 // Burgess HDR
		color = max(mix(color * 0.6, color * 1.2, color) - 0.004, 0.0);

		return color * (6.2 * color + 0.05) / (color * (6.2 * color + 2.3) + 0.06);
	#elif TONEMAP == 8 // Uncharted 2
		/*
			https://github.com/dmnsgn/glsl-tone-map/blob/main/uncharted2.glsl

			Copyright (C) 2019 Damien Seguin

			Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
		*/

		color *= 2.0;

		return (fma(fma(color, vec3(0.15), vec3(0.05)), color, vec3(0.004)) / fma(fma(color, vec3(0.15), vec3(0.5)), color, vec3(0.06)) - 0.2/3.0) / (19.38/24.476 - 0.2/3.0);
	#elif TONEMAP == 9 // SBDT
		/*
			https://github.com/bevyengine/bevy/blob/main/crates/bevy_core_pipeline/src/tonemapping/tonemapping_shared.wgsl

			MIT License

			Permission is hereby granted, free of charge, to any person obtaining a copy
			of this software and associated documentation files (the "Software"), to deal
			in the Software without restriction, including without limitation the rights
			to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
			copies of the Software, and to permit persons to whom the Software is
			furnished to do so, subject to the following conditions:

			The above copyright notice and this permission notice shall be included in all
			copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
			IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
			FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
			AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
			LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
			OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
			SOFTWARE.
		*/

		immut vec3 ycbcr = color * mat3(
			0.2126, 0.7152, 0.0722,
			-0.1146, -0.3854, 0.5,
			0.5, -0.4542, -0.0458
		);

		immut float bt = sbdt_curve(length(ycbcr.gb) * 2.4);
		immut float desat = max(fma(bt, 0.8, -0.56), 0.0);

		return mix(
			color * max(0.0, sbdt_curve(ycbcr.r) / max(1.0e-5, dot(color, vec3(0.2126, 0.7152, 0.0722)))),
			sbdt_curve(mix(color, ycbcr.rrr, desat * desat)),
			bt * bt
		) * 0.97;
	#endif
}