in vec3 vaNormal;
in vec4 at_tangent;

out TBN {
	layout(location = 0) flat vec3 normal;
	layout(location = 0, component = 3) flat float handedness;
	layout(location = 1) flat vec3 tangent;
} tbn_comp;

void init_tbn_v() {
	tbn_comp.normal = normalize(normalMatrix * vaNormal);
	tbn_comp.handedness = at_tangent.w;
	tbn_comp.tangent = normalize(normalMatrix * at_tangent.xyz);
}

void init_tbn_w() {
	tbn_comp.normal = normalize(mat3(gbufferModelViewInverse) * normalMatrix * vaNormal);
	tbn_comp.handedness = at_tangent.w;
	tbn_comp.tangent = normalize(mat3(gbufferModelViewInverse) * normalMatrix * at_tangent.xyz);
}