float linear(float srgb) {
	return srgb <= 0.04045 ? srgb / 12.92 : pow((srgb + 0.055) / 1.055, 2.4);
}

float srgb(float linear) {
	return linear <= 0.0031308 ? 12.92 * linear : 1.055 * pow(linear, 1.0/2.4) - 0.055;
}

vec3 linear(vec3 srgb) {
	return mix(
		pow((srgb + 0.055) / 1.055, vec3(2.4)),
		srgb / 12.92,
		lessThanEqual(srgb, vec3(0.04045))
	);
}

vec3 srgb(vec3 linear) {
	return mix(
		1.055 * pow(linear, vec3(1.0/2.4)) - 0.055,
		12.92 * linear,
		lessThanEqual(linear, vec3(0.0031308))
	);
}

#ifdef REAL_FLOAT16
	float16_t linear(float16_t srgb) {
		return srgb <= float16_t(0.04045) ? srgb / float16_t(12.92) : pow((srgb + float16_t(0.055)) / float16_t(1.055), float16_t(2.4));
	}

	float16_t srgb(float16_t linear) {
		return linear <= float16_t(0.0031308) ? float16_t(12.92) * linear : float16_t(1.055) * pow(linear, float16_t(1.0/2.4)) - float16_t(0.055);
	}

	f16vec3 linear(f16vec3 srgb) {
		return mix(
			pow((srgb + float16_t(0.055)) / float16_t(1.055), f16vec3(2.4)),
			srgb / float16_t(12.92),
			lessThanEqual(srgb, f16vec3(0.04045))
		);
	}

	f16vec3 srgb(f16vec3 linear) {
		return mix(
			float16_t(1.055) * pow(linear, f16vec3(1.0/2.4)) - float16_t(0.055),
			float16_t(12.92) * linear,
			lessThanEqual(linear, f16vec3(0.0031308))
		);
	}
#endif