// vec2(normal_bias, slope_scaled_bias)
f16vec2 shadow_bias(float16_t face_lambertian) {
	immut float16_t cosine = clamp(face_lambertian, float16_t(0.0), float16_t(1.0));
	immut float16_t sine = sqrt(float16_t(1.0) - cosine*cosine); // using the Pythagorean identity
	immut float16_t tangent = sine / cosine;

	return f16vec2(sine, min(float16_t(2.0), tangent));
}