#include "/lib/fast_math.glsl"

f16vec2 octa_encode(f16vec3 normal) {
	normal.xy /= dot(abs(normal), f16vec3(1.0));

	if (normal.z < 0.0) normal.xy = step_zero_signed(normal.xy) * (float16_t(1.0) - abs(normal.yx));

	return normal.xy;
}

f16vec3 octa_decode(f16vec2 octa_normal) {
	immut f16vec2 abs_on = abs(octa_normal);
	immut float16_t z = float16_t(1.0) - abs_on.x - abs_on.y;

	return f16vec3(fma(max(-z, float16_t(0.0)).xx, -step_zero_signed(octa_normal), octa_normal), z);
}