uniform float wetness;

#if SM && defined MC_SPECULAR_MAP
	uniform sampler2D specular;

	float16_t map_smoothness(float16_t sm) {
		#if SM_TYPE == 0
			return sm * ((float16_t(SM) + float16_t(wetness)) * float16_t(0.1));
		#else
			return (float16_t(1.0) - sm) * ((float16_t(SM) + float16_t(wetness)) * float16_t(0.1));
		#endif
	}
#else
	float16_t gen_smoothness(float16_t luminance, float16_t avg_luma) {
		//return min(pow(luminance, 3u), 0.75);
		return clamp(
			(luminance - avg_luma + float16_t(0.2) + float16_t(wetness) * float16_t(0.2)) * float16_t(1.25),
			float16_t(0.1),
			float16_t(1.0)
		);
	}
#endif