#ifdef NM
#endif

#if defined NM && defined MC_NORMAL_MAP
	uniform sampler2D normals;
#else
	// Alpha-checked sRGB -> luma conversion that falls back to zero
	float16_t srgbl_a_ck(f16vec4 color, f16vec3 tint) {
		#ifdef ALPHA_CHECK
			return (color.a > float16_t(alphaTestRef)) ? luminance(tint * color.rgb) : float16_t(0.0);
		#else
			return luminance(tint * color.rgb);
		#endif
	}

	vec3 gen_normal(sampler2D source, f16vec3 tint, vec2 coord, uvec2 uv_data, vec2 atlas, float16_t srgb_luma) {
		const float scale = 0.55;
		const float16_t texel_bump = float16_t(0.5);
		const float16_t subtexel_bump = float16_t(0.5);
		const float subtexel_scale = 0.075;

		immut vec2 local_coord = coord - unpackUnorm2x16(uv_data.x);

		immut ivec2 half_texels = ivec2(
			bitfieldExtract(uv_data.y, 0, 16),
			bitfieldExtract(uv_data.y, 16, 16)
		) / (2 << int(textureQueryLod(source, coord).x + 0.5)) - 1;

		f16vec4 bump = srgb_luma.xxxx;

		immut ivec2 local_texel = ivec2(local_coord * atlas);

		const ivec2[] offsets = ivec2[](
			ivec2(-1, 0),
			ivec2(1, 0),
			ivec2(0, -1),
			ivec2(0, 1)
		);
		immut vec2 offset_coord = coord + 0.5/atlas; // this is necessary because... it doesn't work otherwise ¯\_(ツ)_/¯
		immut mat4 neighborhood = transpose(mat4(
			textureGatherOffsets(source, offset_coord, offsets, 0),
			textureGatherOffsets(source, offset_coord, offsets, 1),
			textureGatherOffsets(source, offset_coord, offsets, 2),
			textureGatherOffsets(source, offset_coord, offsets, 3)
		));
		bump = mix(bump, f16vec4(
			srgbl_a_ck(f16vec4(neighborhood[0]), tint),
			srgbl_a_ck(f16vec4(neighborhood[1]), tint),
			srgbl_a_ck(f16vec4(neighborhood[2]), tint),
			srgbl_a_ck(f16vec4(neighborhood[3]), tint)
		), texel_bump * f16vec4(
			local_texel.x > -half_texels.x,
			local_texel.x < half_texels.x,
			local_texel.y > -half_texels.y,
			local_texel.y < half_texels.y
		)); // todo!() disable this on empty hand

		immut vec2 atlas_texel = 1.0 / atlas;
		immut vec2 subtexel = subtexel_scale * atlas_texel;
		immut vec2 half_size = vec2(half_texels) * atlas_texel;
		bump = mix(bump, f16vec4(
			srgbl_a_ck(f16vec4(texture(source, vec2(coord.x - subtexel.x, coord.y))), tint),
			srgbl_a_ck(f16vec4(texture(source, vec2(coord.x + subtexel.x, coord.y))), tint),
			srgbl_a_ck(f16vec4(texture(source, vec2(coord.x, coord.y - subtexel.y))), tint),
			srgbl_a_ck(f16vec4(texture(source, vec2(coord.x, coord.y + subtexel.y))), tint)
		), subtexel_bump * f16vec4(
			local_coord.x > -half_size.x,
			local_coord.x < half_size.x,
			local_coord.y > -half_size.y,
			local_coord.y < half_size.y
		));

		// Thanks to: https://stackoverflow.com/a/5284527/21652346
		return normalize(cross(normalize(vec3(scale, 0.0, bump.y - bump.x)), normalize(vec3(0.0, scale, bump.w - bump.z))));
	}
#endif