// scales a positive float by (2^bits - 1), rounds it and converts it to a uint
uint int_scale(float x, uint bits) {
	return uint(fma(x, float((1u << bits) - 1u), 0.5));
}

uvec2 int_scale(vec2 x, uvec2 bits) {
	return uvec2(fma(x, vec2((uvec2(1u) << bits) - 1u), vec2(0.5)));
}

uvec2 int_scale(vec2 x, uint bits) {
	return int_scale(x, uvec2(bits));
}

uvec3 int_scale(vec3 x, uvec3 bits) {
	return uvec3(fma(x, vec3((uvec3(1u) << bits) - 1u), vec3(0.5)));
}

uvec3 int_scale(vec3 x, uint bits) {
	return int_scale(x, uvec3(bits));
}