#if !defined NETHER && !defined END
	uniform vec3 skyColorLinear;
#endif

uniform vec2 fogState;
uniform vec3 fogColor;
uniform int isEyeInWater;

float16_t fog(vec3 pe) {
	immut float n_dist = max(length(pe.xz), abs(pe.y)) / fogState.x;
	//immut float pbr_fog = 1.0 - exp(lowp_rcp(fogState.y) * -0.25 * n_dist); // Beer–Lambert law https://discord.com/channels/237199950235041794/276979724922781697/612009520117448764
	immut float16_t edge_fog = min(float16_t(pow(n_dist, fogState.y)), float16_t(1.0));

	return edge_fog;
}

float16_t sky_fog(float16_t height) {
	height = max(height, float16_t(0.0));

	return min(float16_t(0.25) / fma(height, height, float16_t(0.25)) + float16_t(isEyeInWater), float16_t(1.0));
}

#ifndef NETHER
	#ifdef END
		vec3 sky(vec3 n_pe) {
			return mix(rand(fma(trunc(gl_GlobalInvocationID.xy * 0.25), vec2(4.0), frameTimeCounter.xx)).xxx, rand(floor(n_pe.xz * 1024.0 + frameTimeCounter * 1)).rrr * vec3(0.05, 0.0, 0.05) * (1.25 - n_pe.y), 0.99);
		}
	#else
		vec3 sky(float16_t sky_fog, vec3 dir, vec3 sun_dir) {
			vec3 color = mix(f16vec3(skyColorLinear), linear(f16vec3(fogColor)), sky_fog);

			#if SUN_BLOOM || SKY_BLOOM
				if (isEyeInWater == 0) {
					immut float proximity = dot(dir, sun_dir);

					immut float sun = max(0.0, proximity); // * skyState.y // make this only apply to edge fog, not pbr
					immut float moon = max(0.0, -proximity) * skyState.z * 0.2; // * (1.0 - skyState.y)

					color = fma(min(skyState.y + 0.5, 1.0) * vec3(SUN_BLOOM * pow(sun, 256u) + skyState.y * SKY_BLOOM * pow(sun, 3u)), 0.15 * skylight(), color);
					color = fma(vec3(SUN_BLOOM * pow(moon, 256u) + SKY_BLOOM * pow(moon, 3u)), vec3(0.0104, 0.0112, 0.0152), color);
				}
			#endif

			return color;
		}
	#endif
#endif