/*bool sign_bit(float v) {
	return bitfieldExtract(floatBitsToUint(v), 0, 1) == 1u;
}*/

#ifdef REAL_FLOAT16
	f16vec3 step_zero(f16vec3 v) { return step(float16_t(0.0), v); }
	f16vec2 step_zero_signed(f16vec2 v) { return fma(step(float16_t(0.0), v), f16vec2(2.0), f16vec2(-1.0)); }
#endif

/*
	https://github.com/GPUOpen-LibrariesAndSDKs/FidelityFX-SDK/blob/main/sdk/include/FidelityFX/gpu/ffx_core_gpu_common.h

	Copyright (C) 2024 Advanced Micro Devices, Inc.

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files(the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions :

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.
*/

float lowp_rcp(float v) { return uintBitsToFloat(0x7ef07ebbu - floatBitsToUint(v)); }
// float lowp_sqrt(float v) { return uintBitsToFloat((floatBitsToUint(v) >> 1u) + 0x1fbc4639u); }
// float lowp_inversesqrt(float v) { return uintBitsToFloat(0x5f347d74u - (floatBitsToUint(v) >> 1u)); }

const float inf = uintBitsToFloat(0x7f800000u);

// step(0.0, v)
vec3 step_zero(vec3 v) { return clamp(v * inf, 0.0, 1.0); }

// step(0.0, v) * 2.0 - 1.0
vec2 step_zero_signed(vec2 v) { return clamp(v * inf, -1.0, 1.0); }