#version 460 core

#define CONST_IMMUT 1 // [0 1 2]
#define MINMAX_3 1 // [0 1 2 3]
#define MUL_32x16 1 // [0 1 2 3]
#define SIZED_16_8
#define NVIDIA_ASSUME_SHADER5
// #define AMD_ASSUME_FLOAT16
// #define AMD_ASSUME_INT16

#if (CONST_IMMUT == 1 && (defined MC_GL_VENDOR_NVIDIA || defined MC_GL_DRIVER_GEFORCE)) || CONST_IMMUT == 2
	#define immut const
#else
	#define immut
#endif

#if (MINMAX_3 >= 1 && defined MC_GL_AMD_shader_trinary_minmax) || (MINMAX_3 >= 2 && (defined MC_GL_VENDOR_AMD || defined MC_GL_RENDERER_RADEON)) || MINMAX_3 >= 3
	#extension GL_AMD_shader_trinary_minmax : require
#else
	#define min3(v0, v1, v2) min(v0, min(v1, v2))
	#define max3(v0, v1, v2) max(v0, max(v1, v2))
#endif

#if (MUL_32x16 >= 1 && defined MC_GL_INTEL_shader_integer_functions2) || (MUL_32x16 >= 2 && (defined MC_GL_VENDOR_INTEL || defined MC_GL_RENDERER_INTEL)) || MUL_32x16 >= 3
	#extension GL_INTEL_shader_integer_functions2 : require
#else
	#define multiply32x16(v0, v1) (v0 * v1)
#endif

#ifdef NVIDIA_ASSUME_SHADER5
#endif
#ifdef AMD_ASSUME_FLOAT16
#endif
#ifdef AMD_ASSUME_INT16
#endif

#ifdef SIZED_16_8
	#if defined MC_GL_NV_gpu_shader5 || (defined NVIDIA_ASSUME_SHADER5 && (defined MC_GL_VENDOR_NVIDIA || defined MC_GL_DRIVER_GEFORCE))
		#extension GL_NV_gpu_shader5 : require
		#define REAL_FLOAT16
		#define REAL_INT16
		#define REAL_INT8
		// REAL_MAT16 doesn't seem to work :/
	#endif

	#if defined MC_GL_AMD_gpu_shader_half_float || (defined AMD_ASSUME_FLOAT16 && (defined MC_GL_VENDOR_AMD || defined MC_GL_RENDERER_RADEON))
		#extension GL_AMD_gpu_shader_half_float : require
		#define REAL_FLOAT16
		// #define REAL_MAT16 // seems to cause some issues with casting :/
	#endif

	#if defined MC_GL_AMD_gpu_shader_int16 || (defined AMD_ASSUME_INT16 && (defined MC_GL_VENDOR_AMD || defined MC_GL_RENDERER_RADEON))
		#extension GL_AMD_gpu_shader_int16 : require
		#define REAL_INT16
	#endif

	#ifdef MC_GL_EXT_shader_16bit_storage
		#extension GL_EXT_shader_16bit_storage : require
		#define REAL_FLOAT16
		#define REAL_INT16
	#endif

	#ifdef MC_GL_EXT_shader_8bit_storage
		#extension GL_EXT_shader_8bit_storage : require
		#define REAL_INT8
	#endif

	#ifdef MC_GL_EXT_shader_explicit_arithmetic_types_float16
		#extension GL_EXT_shader_explicit_arithmetic_types_float16 : require
		#define REAL_FLOAT16
		// #define REAL_MAT16
	#endif

	#ifdef MC_GL_EXT_shader_explicit_arithmetic_types_int16
		#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
		#define REAL_INT16
	#endif

	#ifdef MC_GL_EXT_shader_explicit_arithmetic_types_int8
		#extension GL_EXT_shader_explicit_arithmetic_types_int8 : require
		#define REAL_INT8
	#endif
#endif

#ifndef REAL_FLOAT16
	#define float16_t float
	#define f16vec2 vec2
	#define f16vec3 vec3
	#define f16vec4 vec4
#endif

#ifndef REAL_MAT16
	#define f16mat2 mat2
	#define f16mat2x3 mat2x3
	#define f16mat2x4 mat2x4

	#define f16mat3x2 mat3x2
	#define f16mat3 mat3
	#define f16mat3x4 mat3x4

	#define f16mat4x2 mat4x2
	#define f16mat4x3 mat4x3
	#define f16mat4 mat4
#endif

#ifndef REAL_INT16
	#define int16_t int
	#define i16vec2 ivec2
	#define i16vec3 ivec3
	#define i16vec4 ivec4

	#define uint16_t uint
	#define u16vec2 uvec2
	#define u16vec3 uvec3
	#define u16vec4 uvec4
#endif

#ifndef REAL_INT8
	#define int8_t int
	#define i8vec2 ivec2
	#define i8vec3 ivec3
	#define i8vec4 ivec4

	#define uint8_t uint
	#define u8vec2 uvec2
	#define u8vec3 uvec3
	#define u8vec4 uvec4
#endif

// #extension GL_EXT_shader_integer_mix : require
// #extension GL_ARB_gpu_shader_int64 : require
// #extension GL_AMD_gpu_shader_int64 : require

// #extension GL_KHR_shader_subgroup_basic : require
// #extension GL_KHR_shader_subgroup_quad : require
// #extension GL_KHR_shader_subgroup_vote : require
// #extension GL_KHR_shader_subgroup_arithmetic: require