#define VERSION v // [v]

// Lighting & Shadows
	#define SUNLIGHT 2.5 // [0.5 0.75 1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 32.25 3.5 3.75 4]
	#define AMBIENT 0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	#define ENTITY_SHADOWS
	#define PLAYER_SHADOWS
	#define BLOCK_ENTITY_SHADOWS
	#define SSS 5 // [0 1 2 3 4 5 6 7 8 9 10]
	#define SHADOW_BLUR 2 // [0 1 2]
	#define SHADOW_FADE_DIST 0.15 // [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
	#define SHADOW_DIST 10 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32]

	const int shadowMapResolution = 2048; // [128 256 512 1024 2048 4096 8192]

// Post Processing
	#define TONEMAP 1 // [0 1 2 3 4 5 6 7 8 9]
	#define RCAS
	#define SHARPNESS 0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

	// Color Grading
		#define SATURATION 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define RED_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define GREEN_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define BLUE_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define DCG_EXP 5 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_COLOR 3 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_BP 7 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_EXP_SPEED 3.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_COLOR_SPEED 2.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_BP_SPEED 3.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_PEAK_SENS 5 // [1 2 3 4 5 6 7 8 9 10]
		#define DCG_MAX_BP 0.05 // [0.025 0.05 0.075 0.1 0.125 0.15 0.175 0.2]
		#define DCG_SAMPLES 16 // [2 4 8 16 32]

	// SMAA
		#define SMAA_THRESHOLD 0.02 // [0.005 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1]
		#define SMAA_SEARCH 32 // [8 16 32 48 64 80 96 112]
		#define SMAA_SEARCH_DIAG 16 // [0 4 8 12 16 20]
		#define SMAA_CORNER 25 // [0 25 50 75 100]

// Atmospherics
	#define FOG 2 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define RAIN_FOG 6 // [0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30]
	#define WATER_FOG 20 // [0 5 10 15 20 25 30 35 40 45 50]
	#define SUN_BLOOM 3 // [0 1 2 3 4 5]
	#define SKY_BLOOM 1 // [0 1 2 3 4 5]
	#define VL
	#define VL_BASE 2 // [1 2 3 4 5 6 7 8 9 10 12 14 16 18 20 25 30]
	#define VL_SUN 6 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define VL_SKY 4 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]

	/*
		const float sunPathRotation = 25.0; // [5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0]
	*/

// Block Light
	#define INDEXED_BLOCK_LIGHT 5 // [0 1 2 3 4 5 6 7 8 9 10]
	#define IND_ILLUM 0.04 // [0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1]
	// #define HAND_LIGHT
	#define EMISSIVE_REDSTONE_BLOCK
	// #define EMISSIVE_EMERALD_BLOCK
	// #define EMISSIVE_LAPIS_BLOCK

	// Light Index
		#define INDEX_DIST 128 // [32 48 64 80 96 112 128 160 192 224 256]
		#define INDEX_SIZE 3072 // [128 256 512 1024 2048 3072 4096 5120 6144 7168 8192 9216 10240 11264 12288 13312 14336 15360 16384]
		#define MIN_INDEX_LL 3 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]
		#define INDEX_RATE 16 // [2 4 8 16 32 64 128 256]
		#define LOD_FALLOFF 3 // [1 2 3 4 5 6 7]
		#define LAVA_LOD_BIAS 0.8 // [0.0 0.2 0.4 0.6 0.8 1.0 1.2]
		#define LDS_RATIO 0.25 // [0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

// Surface
	#define WATER_OPACITY 70 // [50 60 70 80 90 100]
	#define WAVES 1 // [0 1 2 3 4 5 6 7 8 9 10]
	#define WAVE_SPEED 1.0 // [0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
	#define SPECULAR 8 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define SM 0 // [0 1 2 3 4 5 6 7 8 9 10]
	#define SM_CH r // [r g b a]
	#define SM_TYPE 0 // [0 1]
	// #define NM

// Utility
	// #define COMPASS
	// #define LIGHT_LEVELS

/*
	const float ambientOcclusionLevel = 1.0; // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	const float shadowIntervalSize = 0.0;

	// todo!() try shadowtex1HWMipmap again
	const bool shadowHardwareFiltering0 = true;
	const bool shadowHardwareFiltering1 = true;

	const bool shadowcolor0Clear = true;
	const vec4 shadowcolor0ClearColor = vec4(0.0, 0.0, 0.0, 0.0);
	const int shadowcolor0Format = RGB565;

	const bool colortex0Clear = false;
	const int colortex0Format = RGBA16;

	const bool colortex1Clear = false;
	const int colortex1Format = RGBA16F;

	const bool colortex2Clear = false;
	const int colortex2Format = RGBA8_SNORM;
	
	const bool colortex3Clear = false;
	const int colortex3Format = R32UI;
*/

/*	---Pipeline (outdated)--- 
	> X marks the spot... where a write happens (in the buffer corresponding to the line)

	# --Shadow & Solid Geometry--
	shadow... : ┌> shadow -X┬>
	gtexture  : ┴-----------┼> gbuffers(solid)
	specular  : -SM---------┤   |||
	normals   : -NM---------┘   |||
	colortex3 :                 ||└X-> deferred
	colortex1 :                 ||      └X--------┬> deferred_1 -X->
	lightIndex: ----------------X┼┬------------X--┼>
	indexWrite: -----------------X┴> deferred_a┼X-┼>
	indexRead : -------------------------------X--┴>

	# --Translucent Geometry--
	shadow... : -------┐
	gtexture  : -------┼> gbuffers(translucent)
	specular  : -SM----┤   |
	normals   : -NM----┤   |
	lightIndex: -------┤   |
	indexRead : -------┘   |
	colortex1 : -----------X->

	# --Post-Processing--
	dcgBuffer  : ┌> composite -X┐
	colortex1  : ┴--------------┴> composite1
	colortex0  :                    └X-> composite2              ┌X->
	tempCol    :                          |                ┌X-> composite5
	edge       :                          └-X-> composite4 |
	blendWeight:                                 └X-> composite5
*/

/* ---Packing & Layout---
	// remember "When bit-packing fields into a G-Buffer, put highly correlated bits in the Most Significant Bits (MSBs) and noisy data in the Least Significant Bits (LSBs)."

	┌ colortex0 ┐
	|R |G |B |A |
	└10┴10┴10┴2 ┘
	 |  |  |  └X
	 └[unorm color]: 3x10

	┌ colortex1 ┐
	|R |G |B | A|
	└16┴16┴16┴16┘
	 |  |  |  └[smoothness ("hand" flag stored in sign)]: 1x16
	 └[hdr color]: 3x16

	┌ colortex3 -┐
	|--   R    --|
	└13 13 4 1 1 ┘
	 |  |  | | └X
	 |  |  | └[sss]: 1x1
	 |  |  └[emissive]: 1x4
	 └[light]: 2x13

	┌ colortex2 ┐
	|R |G |B |A |
	└8 ┴8 ┴8 ┴8 ┘
	 |  |  |  |
	 |  |  └[face normal]: 2x8
	 └[texture normal]: 2x8
	// todo!() are these correct?

	┌--- lightIndex ---┐
	|--  R  --|-- G  --|
	└9 9 9 4 1┴11 11 10┘
	 | | | | | |  |  |
	 | | | | | └[color (GRB)]: 11/11/10
	 | | | | └[wide]: 1x1
	 | | | └[brightness]: 1x4
	 └[pos]: 3x9

	// unused half-size alternative
	// not very good
	┌ lightIndex -┐
	|--    R    --|
	└7 7 7 4 2 3 2┘
	 | | | | | | |
	 | | | | └[color]: 2/3/2
	 | | | └[brightness]: 1x4
	 └[pos]: 3x8
*/

const float shadowDistanceRenderMul = 0.85;

// probably not 100% optimal but i've not noticed any issues
// could be smaller if we cap the sunPathRotation to the current default
/* https://play.rust-lang.org/
	```rust
	const REN_MUL: f64 = 0.85; // shadowDistanceRenderMul

	fn main() {
		let mut elif = "if";

		for i in 1..=32 {
			let dist = i * 16;

			println!("#{elif} SHADOW_DIST == {i}");
			println!("	const float shadowDistance = {dist};");

			let visible = dist as f64 * REN_MUL;

			let y = visible.min(384.0);
			let plane = (visible * visible * 2.0 + y*y).sqrt().ceil();
			println!("	const float shadowNearPlane = -{plane};");
			println!("	const float shadowFarPlane = {plane};");

			elif = "elif";
		}

		println!("#endif");
	}
	```
*/

#if SHADOW_DIST == 1
	const float shadowDistance = 16;
	const float shadowNearPlane = -24;
	const float shadowFarPlane = 24;
#elif SHADOW_DIST == 2
	const float shadowDistance = 32;
	const float shadowNearPlane = -48;
	const float shadowFarPlane = 48;
#elif SHADOW_DIST == 3
	const float shadowDistance = 48;
	const float shadowNearPlane = -71;
	const float shadowFarPlane = 71;
#elif SHADOW_DIST == 4
	const float shadowDistance = 64;
	const float shadowNearPlane = -95;
	const float shadowFarPlane = 95;
#elif SHADOW_DIST == 5
	const float shadowDistance = 80;
	const float shadowNearPlane = -118;
	const float shadowFarPlane = 118;
#elif SHADOW_DIST == 6
	const float shadowDistance = 96;
	const float shadowNearPlane = -142;
	const float shadowFarPlane = 142;
#elif SHADOW_DIST == 7
	const float shadowDistance = 112;
	const float shadowNearPlane = -165;
	const float shadowFarPlane = 165;
#elif SHADOW_DIST == 8
	const float shadowDistance = 128;
	const float shadowNearPlane = -189;
	const float shadowFarPlane = 189;
#elif SHADOW_DIST == 9
	const float shadowDistance = 144;
	const float shadowNearPlane = -213;
	const float shadowFarPlane = 213;
#elif SHADOW_DIST == 10
	const float shadowDistance = 160;
	const float shadowNearPlane = -236;
	const float shadowFarPlane = 236;
#elif SHADOW_DIST == 11
	const float shadowDistance = 176;
	const float shadowNearPlane = -260;
	const float shadowFarPlane = 260;
#elif SHADOW_DIST == 12
	const float shadowDistance = 192;
	const float shadowNearPlane = -283;
	const float shadowFarPlane = 283;
#elif SHADOW_DIST == 13
	const float shadowDistance = 208;
	const float shadowNearPlane = -307;
	const float shadowFarPlane = 307;
#elif SHADOW_DIST == 14
	const float shadowDistance = 224;
	const float shadowNearPlane = -330;
	const float shadowFarPlane = 330;
#elif SHADOW_DIST == 15
	const float shadowDistance = 240;
	const float shadowNearPlane = -354;
	const float shadowFarPlane = 354;
#elif SHADOW_DIST == 16
	const float shadowDistance = 256;
	const float shadowNearPlane = -377;
	const float shadowFarPlane = 377;
#elif SHADOW_DIST == 17
	const float shadowDistance = 272;
	const float shadowNearPlane = -401;
	const float shadowFarPlane = 401;
#elif SHADOW_DIST == 18
	const float shadowDistance = 288;
	const float shadowNearPlane = -425;
	const float shadowFarPlane = 425;
#elif SHADOW_DIST == 19
	const float shadowDistance = 304;
	const float shadowNearPlane = -448;
	const float shadowFarPlane = 448;
#elif SHADOW_DIST == 20
	const float shadowDistance = 320;
	const float shadowNearPlane = -472;
	const float shadowFarPlane = 472;
#elif SHADOW_DIST == 21
	const float shadowDistance = 336;
	const float shadowNearPlane = -495;
	const float shadowFarPlane = 495;
#elif SHADOW_DIST == 22
	const float shadowDistance = 352;
	const float shadowNearPlane = -519;
	const float shadowFarPlane = 519;
#elif SHADOW_DIST == 23
	const float shadowDistance = 368;
	const float shadowNearPlane = -542;
	const float shadowFarPlane = 542;
#elif SHADOW_DIST == 24
	const float shadowDistance = 384;
	const float shadowNearPlane = -566;
	const float shadowFarPlane = 566;
#elif SHADOW_DIST == 25
	const float shadowDistance = 400;
	const float shadowNearPlane = -589;
	const float shadowFarPlane = 589;
#elif SHADOW_DIST == 26
	const float shadowDistance = 416;
	const float shadowNearPlane = -613;
	const float shadowFarPlane = 613;
#elif SHADOW_DIST == 27
	const float shadowDistance = 432;
	const float shadowNearPlane = -637;
	const float shadowFarPlane = 637;
#elif SHADOW_DIST == 28
	const float shadowDistance = 448;
	const float shadowNearPlane = -660;
	const float shadowFarPlane = 660;
#elif SHADOW_DIST == 29
	const float shadowDistance = 464;
	const float shadowNearPlane = -678;
	const float shadowFarPlane = 678;
#elif SHADOW_DIST == 30
	const float shadowDistance = 480;
	const float shadowNearPlane = -694;
	const float shadowFarPlane = 694;
#elif SHADOW_DIST == 31
	const float shadowDistance = 496;
	const float shadowNearPlane = -710;
	const float shadowFarPlane = 710;
#elif SHADOW_DIST == 32
	const float shadowDistance = 512;
	const float shadowNearPlane = -726;
	const float shadowFarPlane = 726;
#endif