#include "/lib/core.glsl"
#include "/lib/config.glsl"

uniform vec3 shadowLightDirection, shadowProjScale;
uniform mat3 normalMatrix;
uniform mat4 gbufferModelViewInverse, modelViewMatrix, projectionMatrix, shadowModelView, textureMatrix;
uniform sampler2D gtexture;

in vec2 vaUV0;
in vec3 vaPosition;
in vec4 vaColor;

#include "/lib/vertex_block_light.glsl"

#if !defined NO_SKYLIGHT && !(defined NM && defined MC_NORMAL_MAP)
	in vec2 mc_midTexCoord;
#endif

#include "/lib/tbn/vsh.glsl"
#include "/lib/distort.glsl"
#include "/lib/srgb.glsl"

out VertexData {
	layout(location = 2) vec2 texel;
	layout(location = 3) vec3 tint;

	#ifndef NO_SKYLIGHT
		layout(location = 4) vec3 view;
		layout(location = 5) vec3 s_ndc;

		#if !(defined NM && defined MC_NORMAL_MAP)
			layout(location = 6) flat uvec2 uv_data;
		#endif
	#endif
} v;

void main() {
	immut vec3 view = mat4x3(modelViewMatrix) * vec4(vaPosition, 1.0);
	gl_Position = projectionMatrix * vec4(view, 1.0);

	init_tbn_v();

	immut vec3 pe = mat3(gbufferModelViewInverse) * view;
	v.tint = vec3(linear(f16vec3(vaColor.rgb)) * indexed_block_light(pe, f16vec3(mat3(gbufferModelViewInverse) * tbn_comp.normal)));

	immut vec2 atlas = vec2(textureSize(gtexture, 0));
	immut vec2 coord = mat4x2(textureMatrix) * vec4(vaUV0, 0.0, 1.0);
	v.texel = coord * atlas;

	#ifndef NO_SKYLIGHT
		v.view = view.xyz;

		#if !(defined NM && defined MC_NORMAL_MAP)
			immut uvec2 texels = uvec2(fma(abs(coord - mc_midTexCoord), atlas * 2.0, vec2(0.5)));
			v.uv_data = uvec2(packUnorm2x16(mc_midTexCoord), bitfieldInsert(texels.x, texels.y, 16, 16));
		#endif

		immut float lambertian = dot(tbn_comp.normal, shadowLightDirection);

		vec3 s_ndc = shadowProjScale * (mat3(shadowModelView) * (pe + gbufferModelViewInverse[3].xyz));
		s_ndc.xy = distort(s_ndc.xy);
		float s_bias = 0.00005 / lambertian;

		#if SSS && defined TERRAIN
			// todo!() check that this makes sense
			if (mc_Entity.x == 0.0 && lambertian < 0.0) s_bias *= -1.0;
		#endif

		s_ndc.z -= s_bias;
		v.s_ndc = fma(s_ndc, vec3(0.5), vec3(0.5));
	#endif
}