#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1 */
layout(location = 0) out vec4 colortex1;
layout(depth_greater) out float gl_FragDepth;

uniform float alphaTestRef;
uniform vec3 sunDirectionPlr;
uniform sampler2D gtexture;

#include "/lib/srgb.glsl"

#ifndef NO_SKYLIGHT
	uniform mat4 gbufferModelViewInverse;

	#include "/lib/luminance.glsl"
	#include "/lib/skylight.glsl"
	#include "/lib/material/specular.glsl"
	#include "/lib/material/normal.glsl"
	#include "/lib/sample_shadow.glsl"
#endif

#include "/lib/tbn/fsh.glsl"

in VertexData {
	layout(location = 2) vec2 texel;
	layout(location = 3) vec3 tint;

	#ifndef NO_SKYLIGHT
		layout(location = 4) vec3 view;
		layout(location = 5) vec3 s_ndc;

		#if !(defined NM && defined MC_NORMAL_MAP)
			layout(location = 6) flat uvec2 uv_data;
		#endif
	#endif
} v;

void main() {
	f16vec4 color = f16vec4(texelFetch(gtexture, ivec2(v.texel), 0));
	if (color.a < float16_t(alphaTestRef)) discard;

	immut f16vec3 tint = f16vec3(v.tint);
	color.rgb *= tint;

	#ifndef NO_SKYLIGHT
		#if SM && defined MC_SPECULAR_MAP
			//immut float16_t smoothness = map_smoothness(texelFetch(specular, ivec2(v.texel), 0).SM_CH);
		#else
			//immut float16_t smoothness = gen_smoothness(luminance(color.rgb * srgb(v.tint)), 0.8);
		#endif

		immut mat3 tbn = get_tbn();

		#if defined NM && defined MC_NORMAL_MAP
			immut vec3 v_tex_normal = normalize(tbn * fma(texelFetch(normals, ivec2(v.texel), 0).rgb, vec3(2.0), vec3(-1.0)));
		#else
			immut vec2 atlas = vec2(textureSize(gtexture, 0));
			immut vec3 v_tex_normal = tbn * gen_normal(gtexture, tint, v.texel / atlas, v.uv_data, atlas, luminance(color.rgb));
		#endif
	#endif

	color.rgb = linear(color.rgb);

	#ifndef NO_SKYLIGHT
		color.rgb *= skylight();
		// todo!() proper shadow map stuff
	#endif

	colortex1 = color;
}