#include "/lib/core.glsl"
#include "/lib/config.glsl"

uniform mat3 normalMatrix;
uniform mat4 gbufferModelViewInverse, modelViewMatrix, projectionMatrix, textureMatrix;
uniform sampler2D gtexture;

#ifdef HAND_LIGHT
	#include "/buf/hand_light.glsl"
#endif

in vec2 vaUV0;
in vec3 vaPosition;
in vec4 vaColor;

#if (INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS) || !(defined NM && defined MC_NORMAL_MAP)
	in vec2 mc_midTexCoord;
#endif

#include "/lib/tbn/vsh.glsl"
#include "/lib/norm_uv2.glsl"
#include "/lib/un11_11_10.glsl"

out VertexData {
	layout(location = 2) vec2 texel;
	layout(location = 3) flat uint tint;
	layout(location = 3, component = 1) flat uint out_colortex3;

	#if !(defined NM && defined MC_NORMAL_MAP)
		layout(location = 3, component = 2) flat uvec2 uv_data;
	#endif
} v;

void main() {
	gl_Position = projectionMatrix * vec4(mat4x3(modelViewMatrix) * vec4(vaPosition, 1.0), 1.0);
	v.tint = pack_un11_11_10(vaColor.rgb);

	immut uint8_t emission = uint8_t(0u); // todo!()

	f16vec2 light = norm_uv2();
	light.y = min(light.y + float16_t(AMBIENT + 0.25), float16_t(1.0));
	immut uvec2 scaled_light = int_scale(light, 13u);

	v.out_colortex3 = bitfieldInsert(
		bitfieldInsert(scaled_light.x, scaled_light.y, 13, 13),
		emission, 26, 4
	);

	immut vec2 atlas = vec2(textureSize(gtexture, 0));
	immut vec2 coord = mat4x2(textureMatrix) * vec4(vaUV0, 0.0, 1.0);
	v.texel = coord * atlas;

	#if !(defined NM && defined MC_NORMAL_MAP)
		immut uvec2 texels = uvec2(fma(abs(coord - mc_midTexCoord), atlas * 2.0, vec2(0.5)));
		v.uv_data = uvec2(packUnorm2x16(mc_midTexCoord), bitfieldInsert(texels.x, texels.y, 16, 16));
	#endif

	init_tbn_w();
}