#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1,2,3 */
layout(location = 0) out vec4 colortex1;
layout(location = 1) out vec4 colortex2;
layout(location = 2) out uint colortex3;
layout(depth_greater) out float gl_FragDepth;

uniform float alphaTestRef;
uniform sampler2D gtexture;

#include "/lib/tbn/fsh.glsl"
#include "/lib/octa_normal.glsl"
#include "/lib/luminance.glsl"
#include "/lib/material/normal.glsl"
#include "/lib/material/specular.glsl"
#include "/lib/un11_11_10.glsl"

in VertexData {
	layout(location = 2) vec2 texel;
	layout(location = 3) flat uint tint;
	layout(location = 3, component = 1) flat uint out_colortex3;

	#if !(defined NM && defined MC_NORMAL_MAP)
		layout(location = 3, component = 2) flat uvec2 uv_data;
	#endif
} v;

void main() {
	f16vec4 color = f16vec4(texelFetch(gtexture, ivec2(v.texel), 0));
	if (color.a < float16_t(alphaTestRef)) discard;

	colortex3 = v.out_colortex3;

	immut f16vec3 tint = unpack_un11_11_10(v.tint);
	color.rgb *= tint;

	immut mat3 tbn = get_tbn();

	#if defined NM && defined MC_NORMAL_MAP
		immut f16vec3 w_tex_normal = normalize(f16vec3(tbn * fma(texelFetch(normals, ivec2(v.texel), 0).rgb, vec3(2.0), vec3(-1.0))));
	#else
		immut vec2 atlas = vec2(textureSize(gtexture, 0));
		immut f16vec3 w_tex_normal = normalize(f16vec3(tbn * gen_normal(gtexture, tint, v.texel / atlas, v.uv_data, atlas, luminance(color.rgb))));
	#endif

	colortex2 = vec4(
		octa_encode(w_tex_normal),
		octa_encode(f16vec3(tbn[2]))
	);

	immut float16_t smoothness =
		#if SM && defined MC_SPECULAR_MAP
			map_smoothness(float16_t(texelFetch(specular, ivec2(v.texel), 0).SM_CH));
		#else
			gen_smoothness(luminance(color.rgb), float16_t(0.8));
		#endif

	// Set negative sign bit for colortex1 hand flag
	colortex1 = vec4(color.rgb, smoothness * -1.0);
}