#include "/lib/core.glsl"

uniform mat4 gbufferModelViewInverse, modelViewMatrix, projectionMatrix;

in vec3 vaPosition;
in vec4 vaColor;

out VertexData {
	layout(location = 0) flat vec3 tint;
	layout(location = 1) vec3 pe;
} v;

void main() {
	v.tint = vaColor.rgb;

	immut vec3 view = mat4x3(modelViewMatrix) * vec4(vaPosition, 1.0);
	v.pe = mat3(gbufferModelViewInverse) * view;

	gl_Position = projectionMatrix * vec4(view, 1.0);
}