#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1 */
layout(location = 0) out vec4 colortex1;
layout(depth_unchanged) out float gl_FragDepth;

uniform vec3 sunDirectionPlr;

in VertexData {
	layout(location = 0) flat vec3 tint;
	layout(location = 1) vec3 pe;
} v;

#include "/lib/srgb.glsl"
#include "/lib/skylight.glsl"
#include "/lib/fog.glsl"

void main() {
	immut f16vec3 color = f16vec3(v.tint) * float16_t(0.5) + float16_t(0.25) * skylight();

	immut vec2 abs_pe = abs(v.pe.xz);
	immut float16_t fog = min(float16_t(pow(max(abs_pe.x, abs_pe.y) * 0.6 / fogState.x, fogState.y)), float16_t(1.0));

	immut float16_t dist = length(f16vec3(v.pe));

	immut vec3 n_pe = normalize(v.pe);
	immut f16vec3 fog_col = f16vec3(sky(sky_fog(float16_t(n_pe.y)), n_pe, sunDirectionPlr));

	colortex1 = vec4(
		mix(mix(color, fog_col, float16_t(0.25)), fog_col, fog),
		min(dist * float16_t(0.01), float16_t(0.75)) * (float16_t(1.0) - fog)
	);
}