#include "/lib/core.glsl"

out gl_PerVertex {
	vec4 gl_Position;
};

uniform mat4 modelViewMatrix, projectionMatrix, textureMatrix;

in vec2 vaUV0;
in vec3 vaPosition;

out VertexData { layout(location = 0) vec2 coord; } v;

void main() {
	gl_Position = projectionMatrix * vec4(mat4x3(modelViewMatrix) * vec4(vaPosition, 1.0), 1.0);

	v.coord = mat4x2(textureMatrix) * vec4(vaUV0, 0.0, 1.0);
}