#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* Light Index Deduplication */

#if INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS // todo!() just disable this pass entirely when false
	layout(local_size_x = min(gl_MaxComputeWorkGroupSize.x, INDEX_SIZE), local_size_y = 1, local_size_z = 1) in;

	uniform bool rebuildIndex;
	uniform vec3 invCameraPositionDeltaInt;
	uniform mat4 gbufferModelViewInverse;

	#include "/buf/index.glsl"

	shared uint sh_culled_len;
	shared uint[index.data.length()] sh_index_data;
	shared uint16_t[index.data.length()] sh_index_color;
#else
	layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;
#endif

const ivec3 workGroups = ivec3(1, 1, 1);

void main() {
	#if INDEXED_BLOCK_LIGHT && !defined LIGHT_LEVELS
		immut uint16_t local_invocation_i = uint16_t(gl_LocalInvocationIndex);

		if (rebuildIndex) {
			if (local_invocation_i == uint16_t(0u)) sh_culled_len = 0u;

			// if (index.queue > index.data.length()) { index.len = uint16_t(0u); return; }

			immut uint16_t len = min(uint16_t(index.queue), uint16_t(index.data.length()));
			for (uint16_t i = local_invocation_i; i < len; i += uint16_t(gl_WorkGroupSize.x)) {
				sh_index_data[i] = index.data[i];
				sh_index_color[i] = index.color[i];
			}

			barrier();

			for (uint16_t i = local_invocation_i; i < len; i += uint16_t(gl_WorkGroupSize.x)) {
				immut uint data = sh_index_data[i];
				immut uint16_t color = sh_index_color[i];

				bool unique = true;

				// cull identical lights
				for (uint16_t j = uint16_t(0u); unique && j < i; ++j) if (sh_index_data[j] == data && sh_index_color[j] == color) unique = false;

				// cull different colored lights at the same pos, comparing the color bits to make it deterministic
				for (uint16_t j = uint16_t(0u); unique && j < len; ++j) if (sh_index_data[j] == data && sh_index_color[j] < color) unique = false;

				if (unique) {
					immut uint16_t i = uint16_t(atomicAdd(sh_culled_len, 1u));
					index.data[i] = data;
					index.color[i] = color;
				}
			}

			barrier();

			if (local_invocation_i == uint16_t(0u)) {
				index.queue = 0u;
				index.offset = vec3(0.0);
				index.len = uint16_t(sh_culled_len);
			}
		} else if (local_invocation_i == uint16_t(0u)) index.offset += invCameraPositionDeltaInt;
	#endif
}