#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* Deferred Lighting Apply, Sky and Fog */

layout(local_size_x = 16, local_size_y = 16, local_size_z = 1) in;
const vec2 workGroupsRender = vec2(1.0, 1.0);

uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse;
uniform sampler2D deferredLight0S, depthtex0;

uniform layout(rgba16f) restrict image2D colorimg1;

#ifndef NETHER
	uniform float frameTimeCounter;
	uniform sampler2D deferredLight1S; // shadowmap light

	#include "/lib/rand.glsl"
	#include "/lib/skylight.glsl"

	#ifndef END
		uniform vec3 sunDirectionPlr;
	#endif
#endif

#ifdef HAND_LIGHT
	readonly
	#include "/buf/hand_light.glsl"
#endif

#include "/lib/view.glsl"
#include "/lib/srgb.glsl"
#include "/lib/fog.glsl"

void main() {
	immut i16vec2 texel = i16vec2(gl_GlobalInvocationID.xy);
	immut float depth = texelFetch(depthtex0, texel, 0).r;
	immut vec2 texel_size = 1.0 / vec2(view());
	immut vec2 coord = fma(gl_GlobalInvocationID.xy, texel_size, 0.5 * texel_size);
	immut vec3 ndc = fma(vec3(coord, depth), vec3(2.0), vec3(-1.0));
	immut vec4 view_undiv = gbufferProjectionInverse * vec4(ndc, 1.0);
	immut vec3 pe = mat3(gbufferModelViewInverse) * (view_undiv.xyz / view_undiv.w);
	immut vec3 n_pe = normalize(pe);

	vec3 color;

	#ifdef NETHER
		immut f16vec3 fog_col = linear(f16vec3(fogColor));
	#elif defined END
		immut f16vec3 fog_col = f16vec3(sky(n_pe));
	#else
		immut float16_t sky_fog_val = sky_fog(float16_t(n_pe.y));
		immut f16vec3 fog_col = f16vec3(sky(sky_fog(float16_t(n_pe.y)), n_pe, sunDirectionPlr));
	#endif

	if (depth < 1.0) {
		color = linear(f16vec3(imageLoad(colorimg1, texel).rgb));

		vec3 light = texelFetch(deferredLight0S, texel, 0).rgb; // block light

		#ifndef NETHER
			light += texelFetch(deferredLight1S, texel, 0).rgb;
		#endif

		color = mix(color * light, fog_col, fog(pe));
	} else {
		#if defined NETHER || defined END
			color = fog_col;
		#else
			immut float16_t stars = max(
				float16_t(1.0) - sky_fog_val - float16_t(skyState.x),
				float16_t(0.0)
			) * smoothstep(
				float16_t(0.999),
				float16_t(1.0),
				float16_t(rand(floor(n_pe.xz * 1000.0 + sin(frameTimeCounter * 1000.0) * 0.2)))
			);

			immut bool sun = all(lessThan(abs(n_pe - sunDirectionPlr), vec3(0.04)));
			immut bool moon = all(lessThan(abs(n_pe + sunDirectionPlr), fma(skyState.z, 0.0025, 0.02).xxx));

			color = fma(skylight(), f16vec3(moon || sun), fog_col + stars);
		#endif
	}

	imageStore(colorimg1, texel, vec4(color, 0.0));
}