#include "/lib/core.glsl"
// #include "/lib/config.glsl"

/* Deferred Indirect Dispatch */

uniform sampler2D depthtex0;

layout(local_size_x = 16, local_size_y = 16, local_size_z = 1) in;
const vec2 workGroupsRender = vec2(1.0, 1.0);

// writeonly
#include "/buf/indirect.glsl"

#ifndef NETHER
	#include "/buf/indirect_sm_lit.glsl"

	uniform vec3 shadowLightDirectionPlr;
	uniform sampler2D colortex2;

	#include "/lib/octa_normal.glsl"
	// #include "/lib/view.glsl"
#endif

shared bool sh_geometry;

#ifndef NETHER
	shared bool sh_sm_lit;
#endif

void main() {
	if (gl_LocalInvocationIndex == 0u) {
		sh_geometry = false;

		#ifndef NETHER
			sh_sm_lit = false;
		#endif
	}

	barrier();

	immut i16vec2 texel = i16vec2(gl_GlobalInvocationID.xy);

	if (texelFetch(depthtex0, texel, 0).r < 1.0) {
		sh_geometry = true;

		#ifndef NETHER
			/*
				immut vec3 abs_pe = abs(mat3(gbufferModelViewInverse) * view_undiv.xyz / view_undiv.w);
			*/

			// if (max3(abs_pe.x, abs_pe.y, abs_pe.z) < shadowDistance * shadowDistanceRenderMul) {
				immut f16vec2 octa_face_normal = f16vec2(texelFetch(colortex2, texel, 0).zw);

				if (dot(octa_decode(octa_face_normal), f16vec3(shadowLightDirectionPlr)) > float16_t(0.0)) {
					sh_sm_lit = true;
				}
			// }
		#endif
	}

	barrier();

	if (gl_LocalInvocationIndex == 0u && sh_geometry) {
		#ifdef REAL_INT16
			immut i16vec2 packed_texel = i16vec2(gl_WorkGroupSize.xy) * i16vec2(gl_WorkGroupID.xy);
		#else
			immut uvec2 first_texel = multiply32x16(gl_WorkGroupSize.xy, gl_WorkGroupID.xy);
			immut uint packed_texel = bitfieldInsert(first_texel.x, first_texel.y, 16, 16);
		#endif

		indirect.coords[atomicAdd(indirect.work_groups.x, 1u)] = packed_texel;

		#ifndef NETHER
			if (sh_sm_lit) indirect_sm_lit.coords[atomicAdd(indirect_sm_lit.work_groups.x, 1u)] = packed_texel;
		#endif
	}
}