#include "/lib/core.glsl"

/* SMAA Neighborhood Blending */

layout(local_size_x = 16, local_size_y = 16, local_size_z = 1) in;
const vec2 workGroupsRender = vec2(1.0, 1.0);

uniform layout(rgba16) restrict writeonly image2D tempCol;
uniform sampler2D blendWeightS, colortex0;

#include "/lib/view.glsl"

/*
	SMAA Neighborhood Blending
	https://github.com/Luracasmus/smaa-mc/blob/main/shaders/composite2.csh

	Copyright (C) 2013 Jorge Jimenez (jorge@iryoku.com)
	Copyright (C) 2013 Jose I. Echevarria (joseignacioechevarria@gmail.com)
	Copyright (C) 2013 Belen Masia (bmasia@unizar.es)
	Copyright (C) 2013 Fernando Navarro (fernandn@microsoft.com)
	Copyright (C) 2013 Diego Gutierrez (diegog@unizar.es)
	Copyright (C) 2024 Luracasmus

	Permission is hereby granted, free of charge, to any person obtaining a copy
	this software and associated documentation files (the "Software"), to deal in
	the Software without restriction, including without limitation the rights to
	use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
	the Software, and to permit persons to whom the Software is furnished to do so,
	subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software. As clarification, there is no
	requirement that the copyright notice and permission be included in binary
	distributions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
	FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
	COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
	IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
	CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

void main() {
	immut i16vec2 texel = i16vec2(gl_GlobalInvocationID.xy);

	immut f16vec4 a = f16vec4(
		texelFetchOffset(blendWeightS, texel, 0, ivec2(1, 0)).w,
		texelFetchOffset(blendWeightS, texel, 0, ivec2(0, 1)).y,
		texelFetch(blendWeightS, texel, 0).zx
	);

	f16vec3 color;

	if (dot(vec4(a), vec4(1.0)) < 1.0e-5) {
		color = f16vec3(texelFetch(colortex0, texel, 0).rgb);
	} else {
		immut bool h = max(a.x, a.z) > max(a.y, a.w);

		immut vec4 blending_offset = h ? vec4(a.x, 0.0, a.z, 0.0) : vec4(0.0, a.y, 0.0, a.w);

		f16vec2 blending_weight = h ? a.xz : a.yw;
		blending_weight /= dot(blending_weight, f16vec2(1.0));

		immut vec2 texel_size = 1.0 / vec2(view());
		immut vec2 coord = fma(vec2(texel), texel_size, 0.5 * texel_size);

		color = blending_weight.x * f16vec3(textureLod(colortex0, fma(blending_offset.xy, texel_size, coord), 0.0).rgb);
		color += blending_weight.y * f16vec3(textureLod(colortex0, fma(blending_offset.zw, -texel_size, coord), 0.0).rgb);
	}

	// color = f16vec3(texelFetch(blendWeightS, texel, 0).xyz);

	imageStore(tempCol, texel, vec4(color, 0.0));
}