#version 120

#include "/settings.glsl"

uniform sampler2D texture;

uniform float blindness;
uniform int worldTime;

in vec4 color;
in vec2 TexCoords;

float smoothTransition(float time) {
    if (time >= 0.0f && time <= 1000.0f) {
        return time / 1000.0f; // Transition from 0 to 1
    } else if (time > 1000.0f && time < 12000.0f) {
        return 1.0f; // Fully enabled
    } else if (time >= 12000.0f && time <= 13000.0f) {
        return 1.0f - (time - 12000.0f) / 1000.0f; // Transition from 1 to 0
    } else {
        return 0.0f; // Fully disabled
    }
}

void main()
{
    vec3 light = vec3(1.-blindness);
    vec4 col = color * vec4(light,1) * texture2D(texture, TexCoords);

	vec4 sky_color;
	#if GREY_WEATHER == 0
	sky_color = col;
	#else
	float state = smoothTransition(worldTime);
	sky_color = mix(vec4(0), vec4(0.75, 0.75, 0.76, 0), state);
	#endif

    //Output the result.
    gl_FragData[0] = sky_color;
}
