#version 120

//Shader by LoLip_p

#include "/settings.glsl"

out vec2 TexCoords;

#if LENS_FLARE_ENABLE == 1
out float sunVisibility;

out vec2 lf1Pos;
out vec2 lf2Pos;
out vec2 lf3Pos;
out vec2 lf4Pos;
out vec2 lf5Pos;
out vec2 lf6Pos;
out vec2 lf7Pos;
out vec2 lf8Pos;
out vec2 lf9Pos;
out vec2 lf10Pos;
out vec2 lf11Pos;
out vec2 lf12Pos;
out vec2 lf13Pos;

uniform float viewWidth;
uniform float viewHeight;
uniform vec3 sunPosition;
uniform mat4 gbufferProjection;
uniform sampler2D depthtex0;
#endif

void main() {
    gl_Position = ftransform();
	TexCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	
	
	#if LENS_FLARE_ENABLE == 1
	vec4 ndcSunPosition = gbufferProjection * vec4(normalize(sunPosition), 1.0);
	ndcSunPosition /= ndcSunPosition.w;
    vec2 pixelSize = vec2(1.0 / viewWidth, 1.0 / viewHeight);   
    sunVisibility = 0.0f;
    vec2 screenSunPosition = vec2(-10.0);
	lf1Pos = lf2Pos = lf3Pos = lf4Pos = vec2(-10.0);
	
    if(ndcSunPosition.x >= -1.0 && ndcSunPosition.x <= 1.0 &&
		ndcSunPosition.y >= -1.0 && ndcSunPosition.y <= 1.0 &&
		ndcSunPosition.z >= -1.0 && ndcSunPosition.z <= 1.0)
	{
		screenSunPosition = ndcSunPosition.xy * 0.5 + 0.5;
		for(int x = -4; x <= 4; x++)
		{
			for(int y = -4; y <= 4; y++)
			{
				float depth = texture2DLod(depthtex0, screenSunPosition.st + vec2(float(x), float(y)) * pixelSize, 0.0).r;
				if(depth > 0.9999)
					sunVisibility += 1.0 / 81.0;
			}
		}
		float shortestDis = min( min(screenSunPosition.s, 1.0 - screenSunPosition.s),
								min(screenSunPosition.t, 1.0 - screenSunPosition.t));
		sunVisibility *= smoothstep(0.0, 0.2, clamp(shortestDis, 0.0, 0.2));
		
		vec2 dir = vec2(0.5) - screenSunPosition;
		lf1Pos = vec2(0.5) + dir * -00000001.00000001;
		lf2Pos = vec2(0.5) + dir * -00000001.00000001;
		lf3Pos = vec2(0.5) + dir * -00000001.00000001;
		lf4Pos = vec2(0.5) + dir * -00000001.00000001;
		lf5Pos = vec2(0.5) + dir * 0.99;
		lf6Pos = vec2(0.5) + dir * 0.49;
		lf7Pos = vec2(0.5) + dir * 0.39;
		lf8Pos = vec2(0.5) + dir * 0.45;
		lf9Pos = vec2(0.5) + dir *  0.20;
		lf10Pos = vec2(0.5) + dir * -0.10;
		lf11Pos = vec2(0.5) + dir * -0.19;
		lf12Pos = vec2(0.5) + dir * 0.20;
		lf13Pos = vec2(0.5) + dir * 0.40;
    }
	#endif
}
